package pl.decerto.hyperon.persistence.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import pl.decerto.hyperon.persistence.model.value.Property;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

/**
 * T - type of model entity
 *
 * @author przemek hertel
 */
public class ModelFactoryImpl<T> implements ModelFactory<T> {

	private static Map<Class<?>, Constructor<?>> cache = new ConcurrentHashMap<>();

	private final Class<T> proxyClass;

	public ModelFactoryImpl(Class<T> proxyClass) {
		this.proxyClass = proxyClass;
	}

	@Override
	public T create(Property p) {

		try {
			return getContructor(proxyClass).newInstance(p);

		} catch (InstantiationException | IllegalAccessException | InvocationTargetException e) {
			throw new HyperonRuntimeException(
				String.format("failed to create proxy [%s] for element: %s", proxyClass.getSimpleName(), p), e);
		}
	}

	@SuppressWarnings("unchecked")
	private Constructor<T> getContructor(Class<T> clazz) {
		Constructor<T> constr = (Constructor<T>) cache.get(clazz);

		if (constr == null) {
			constr = findConstructor();
			cache.put(clazz, constr);
		}

		return constr;
	}

	@SuppressWarnings("unchecked")
	private Constructor<T> findConstructor() {

		try {
			return proxyClass.getConstructor(Property.class);

		} catch (NoSuchMethodException | RuntimeException e) {
			throw new HyperonRuntimeException(
				String.format("Failed to create Adapter [%s] for Property class", proxyClass.getSimpleName()), e);
		}

	}

}
