package pl.decerto.hyperon.persistence.marshaller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

/**
 * @author przemek hertel
 */
public final class LobData {

	/**
	 * non-root entities (only unmapped simple fields)
	 */
	private final List<ExpFragment> entities;

	/**
	 * root entity fragment (only if there are unmapped simple fields)
	 */
	private final ExpFragment root;

	/**
	 * refs found in bundle.
	 */
	private final List<ExpRef> refs;

	private LobData(List<ExpFragment> entities, ExpFragment root, List<ExpRef> refs) {
		this.entities = entities;
		// force list to be sorted
		sort();
		this.root = root;
		this.refs = refs;
	}

	@JsonCreator
	static LobData completeLobData(
		@JsonProperty("entities") List<ExpFragment> entities,
		@JsonProperty("root") ExpFragment root,
		@JsonProperty("refs") List<ExpRef> refs) {

		return new LobData(entities, root, refs);
	}

	public static LobData withoutRootLobData(List<ExpFragment> entities, List<ExpRef> refs) {
		return new LobData(entities, null, refs);
	}

	public List<ExpFragment> getEntities() {
		return entities;
	}

	public List<ExpRef> getRefs() {
		return refs;
	}

	public ExpFragment getRoot() {
		return root;
	}

	private void sort() {
		entities.sort(Comparator.comparingLong(ExpFragment::getId));
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}

		if (!(o instanceof LobData)) {
			return false;
		}

		LobData other = (LobData) o;
		return Objects.equals(this.entities, other.entities) && Objects.equals(this.refs, other.refs);
	}

	@Override
	public int hashCode() {
		return Objects.hash(entities, refs);
	}

	@Override public String toString() {
		return "LobData{" +
			"entities=" + entities +
			", root=" + root +
			", refs=" + refs +
			'}';
	}

}
