package pl.decerto.hyperon.persistence.helper;

import pl.decerto.hyperon.persistence.model.value.ElementType;
import pl.decerto.hyperon.persistence.model.value.Property;

/**
 * @author przemek hertel
 */
public interface PropertyVisitor {

	/** deprecated method to visit whole subtree starting from given property. Use {@link #visit(Property, ElementType)}
	 * @param p current visited property
	 * @param path current property's path
	 * @param type property type
	 */
	@Deprecated
	void visit(Property p, String path, ElementType type);

	/** method to visit whole subtree starting from given property. If property path is needed, use {@link Property#getCanonicalPath()}
	 *
	 * @param p current visited property
	 * @param type property type
	 */
	default void visit(Property p, ElementType type) {
	}
}
