package pl.decerto.hyperon.persistence.helper;

import java.util.IdentityHashMap;
import java.util.Set;

import org.smartparam.engine.util.Separator;

import pl.decerto.hyperon.persistence.model.value.Property;

/**
 * @author przemek hertel
 */
public class IdentitySet {

	private static final Object PRESENT = new Object();

	private final IdentityHashMap<Property, Object> idmap;

	public IdentitySet(int size) {
		idmap = new IdentityHashMap<>(size);
	}

	public IdentitySet() {
		this(64);
	}

	public void add(Property obj) {
		idmap.put(obj, PRESENT);
	}

	public boolean contains(Property obj) {
		return idmap.containsKey(obj);
	}

	public Object remove(Property obj) {
		return idmap.remove(obj);
	}

	public Set<Property> getAll() {
		return idmap.keySet();
	}

	public int size() {
		return idmap.size();
	}

	public String print() {
		StringBuilder sb = new StringBuilder(64);
		for (Property p : getAll()) {
			sb.append(String.format("%.10s, @%d, %s", p.getElementType(), System.identityHashCode(p), p.getPath()));
			sb.append(Separator.DEFAULT.getValue());
		}
		return sb.toString();
	}

}
