// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.validation.TableNameValidator;

/**
 * Entity to table mapping.
 *
 * @author przemek hertel
 */
public class TupleDef {
	private final EntityType entityType;
	private final String tableName;
	/**
	 * all column mappings
	 */
	private final List<TuplePropertyDef> properties = new ArrayList<>();
	/**
	 * maps property name to mapping
	 */
	private final Map<String, TuplePropertyDef> propertiesMap = new HashMap<>();

	public TupleDef(EntityType entityType, String tableName) {
		this.entityType = entityType;
		this.tableName = tableName;
		// security: prevent table name with SQL-injection vulnerability
		TableNameValidator.validateTableName(this.tableName);
	}

	/**
	 * add column mapping to this tuple
	 *
	 * @param column       column name
	 * @param type         mpp type code
	 * @param propertyName property name
	 * @return tuple definition on which this method was invoked
	 */
	public TupleDef add(String column, String type, String propertyName) {
		TuplePropertyDef prop = new TuplePropertyDef(column, type, propertyName);
		properties.add(prop);
		propertiesMap.put(propertyName, prop);
		return this;
	}

	public TupleDef add(String column, String type) {
		return add(column, type, column);
	}

	public String getEntityName() {
		return entityType.getName();
	}

	public int getFieldCount() {
		return properties.size();
	}

	public TuplePropertyDef getProperty(String propertyName) {
		return propertiesMap.get(propertyName);
	}

	public TuplePropertyDef getProperty(int index) {
		return properties.get(index);
	}

	public boolean hasMapping(String propertyName) {
		return propertiesMap.containsKey(propertyName);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		TupleDef tupleDef = (TupleDef) o;
		return Objects.equals(entityType, tupleDef.entityType) && Objects.equals(tableName, tupleDef.tableName) && Objects.equals(properties, tupleDef.properties);
	}

	@Override
	public int hashCode() {
		return Objects.hash(entityType, tableName, properties);
	}

	@Override
	public String toString() {
		return "TupleDef[entity=" + entityType + ", table=" + tableName + ", props=" + properties + ']';
	}

	@java.lang.SuppressWarnings("all")
	public EntityType getEntityType() {
		return this.entityType;
	}

	@java.lang.SuppressWarnings("all")
	public String getTableName() {
		return this.tableName;
	}

	/**
	 * all column mappings
	 */
	@java.lang.SuppressWarnings("all")
	public List<TuplePropertyDef> getProperties() {
		return this.properties;
	}

	/**
	 * maps property name to mapping
	 */
	@java.lang.SuppressWarnings("all")
	public Map<String, TuplePropertyDef> getPropertiesMap() {
		return this.propertiesMap;
	}
}
