// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents data that corresponds to GMO external table (not GENERIC json value).
 *
 * @author przemek hertel
 */
public class Tuple {
	private final TupleDef def;
	private final long id;
	private final long bundleId;
	private final long ownerId;
	private final String collectionName;
	private final List<TupleProperty> properties = new ArrayList<>();
	/**
	 * column name to TupleProperty
	 */
	private Map<String, TupleProperty> propertyMap = new HashMap<>();

	public Tuple(TupleDef def, long id, long bundleId, long ownerId, String collectionName) {
		this.def = def;
		this.id = id;
		this.bundleId = bundleId;
		this.ownerId = ownerId;
		this.collectionName = collectionName;
	}

	public void addProperty(TupleProperty prop) {
		properties.add(prop);
		propertyMap.put(prop.getColumn(), prop);
	}

	public TupleProperty getProperty(String column) {
		return propertyMap.get(column);
	}

	@Override
	public String toString() {
		return "Tuple[" + def.getEntityType().getName() + ", id=" + id + ", owner=" + ownerId + ", ownerprop=" + collectionName + ", props=" + properties + ']';
	}

	@java.lang.SuppressWarnings("all")
	public TupleDef getDef() {
		return this.def;
	}

	@java.lang.SuppressWarnings("all")
	public long getId() {
		return this.id;
	}

	@java.lang.SuppressWarnings("all")
	public long getBundleId() {
		return this.bundleId;
	}

	@java.lang.SuppressWarnings("all")
	public long getOwnerId() {
		return this.ownerId;
	}

	@java.lang.SuppressWarnings("all")
	public String getCollectionName() {
		return this.collectionName;
	}

	@java.lang.SuppressWarnings("all")
	public List<TupleProperty> getProperties() {
		return this.properties;
	}

	/**
	 * column name to TupleProperty
	 */
	@java.lang.SuppressWarnings("all")
	public Map<String, TupleProperty> getPropertyMap() {
		return this.propertyMap;
	}
}
