/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions;

import hudson.model.Result;
import hudson.model.Run;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class BuildResultCondition
extends Condition {
    private boolean matchSuccess;
    private boolean matchUnstable;
    private boolean matchFailure;
    private boolean matchAborted;

    @DataBoundConstructor
    public BuildResultCondition() {
    }

    public boolean getMatchSuccess() {
        return this.matchSuccess;
    }

    @DataBoundSetter
    public void setMatchSuccess(boolean matchSuccess) {
        this.matchSuccess = matchSuccess;
    }

    public boolean getMatchUnstable() {
        return this.matchUnstable;
    }

    @DataBoundSetter
    public void setMatchUnstable(boolean matchUnstable) {
        this.matchUnstable = matchUnstable;
    }

    public boolean getMatchFailure() {
        return this.matchFailure;
    }

    @DataBoundSetter
    public void setMatchFailure(boolean matchFailure) {
        this.matchFailure = matchFailure;
    }

    public boolean getMatchAborted() {
        return this.matchAborted;
    }

    @DataBoundSetter
    public void setMatchAborted(boolean matchAborted) {
        this.matchAborted = matchAborted;
    }

    @Override
    public boolean matches(Run<?, ?> run, RuleConfiguration configuration) {
        Result result = run.getResult();
        if (this.matchSuccess && result == Result.SUCCESS) {
            return true;
        }
        if (this.matchUnstable && result == Result.UNSTABLE) {
            return true;
        }
        if (this.matchFailure && result == Result.FAILURE) {
            return true;
        }
        return this.matchAborted && result == Result.ABORTED;
    }
}

