/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model;

import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.actions.Action;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class Rule
extends AbstractDescribableImpl<Rule> {
    private static final Logger LOG = Logger.getLogger(Rule.class.getName());
    private final List<Condition> conditions;
    private final List<Action> actions;
    private final RuleConfiguration configuration = new RuleConfiguration();
    private transient int matchedTimes;

    @DataBoundConstructor
    public Rule(List<Condition> conditions, List<Action> actions) {
        this.conditions = Util.fixNull(conditions);
        this.actions = Util.fixNull(actions);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    @DataBoundSetter
    public void setMatchAtMost(int matchAtMost) {
        this.configuration.setMatchAtMost(matchAtMost);
    }

    public int getMatchAtMost() {
        return this.configuration.getMatchAtMost();
    }

    @DataBoundSetter
    public void setContinueAfterMatch(boolean continueAfterMatch) {
        this.configuration.setContinueAfterMatch(continueAfterMatch);
    }

    public boolean getContinueAfterMatch() {
        return this.configuration.isContinueAfterMatch();
    }

    public void initialize() {
        this.matchedTimes = 0;
    }

    public boolean validateConditions(Run<?, ?> run) {
        if (this.matchedTimes == this.getMatchAtMost()) {
            LOG.info(String.format("Skipping rule because matched %d times", this.matchedTimes));
            return false;
        }
        for (Condition condition : this.conditions) {
            LOG.info(String.format("Processing condition '%s'", condition.getDescriptor().getDisplayName()));
            boolean conditionMatched = condition.matches(run, this.configuration);
            if (conditionMatched) continue;
            LOG.info(String.format("Condition '%s' does not match", condition.getDescriptor().getDisplayName()));
            return false;
        }
        ++this.matchedTimes;
        return true;
    }

    public void performActions(Run<?, ?> run) throws IOException, InterruptedException {
        for (Action action : this.actions) {
            LOG.info(String.format("Processing action '%s' for build #%d", action.getDescriptor().getDisplayName(), run.getNumber()));
            action.perform(run);
        }
    }
}

