/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import com.github.zafarkhaja.semver.Version;
import java.util.Optional;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import pl.allegro.tech.build.axion.release.ReleaseBranchesConfiguration;
import pl.allegro.tech.build.axion.release.domain.VersionContext;
import pl.allegro.tech.build.axion.release.domain.VersionService;
import pl.allegro.tech.build.axion.release.domain.hooks.ReleaseHooksRunner;
import pl.allegro.tech.build.axion.release.domain.properties.Properties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResult;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResultOutcome;
import pl.allegro.tech.build.axion.release.domain.scm.ScmService;

public class Releaser {
    private static final Logger logger = Logging.getLogger(Releaser.class);
    private final VersionService versionService;
    private final ScmService repository;
    private final ReleaseHooksRunner hooksRunner;

    public Releaser(VersionService versionService, ScmService repository, ReleaseHooksRunner hooksRunner) {
        this.versionService = versionService;
        this.repository = repository;
        this.hooksRunner = hooksRunner;
    }

    public Optional<String> release(Properties properties, ReleaseBranchesConfiguration releaseBranchesConfiguration) {
        if (releaseBranchesConfiguration.shouldRelease()) {
            String message = String.format("Release step skipped since 'releaseOnlyOnReleaseBranches' option is set, and '%s' was not in 'releaseBranchNames' list [%s]", releaseBranchesConfiguration.getCurrentBranch(), String.join((CharSequence)",", releaseBranchesConfiguration.getReleaseBranchNames()));
            logger.quiet(message);
            return Optional.empty();
        }
        VersionContext versionContext = this.versionService.currentVersion(properties.getVersion(), properties.getTag(), properties.getNextVersion());
        Version version = versionContext.getVersion();
        if (versionContext.isSnapshot()) {
            String tagName = properties.getTag().getSerialize().apply(properties.getTag(), version.toString());
            this.hooksRunner.runPreReleaseHooks(properties.getHooks(), properties, versionContext, version);
            logger.quiet("Creating tag: " + tagName);
            this.repository.tag(tagName);
            this.hooksRunner.runPostReleaseHooks(properties.getHooks(), properties, versionContext, version);
            return Optional.of(tagName);
        }
        logger.quiet("Working on released version " + version + ", nothing to release");
        return Optional.empty();
    }

    public ScmPushResult releaseAndPush(Properties rules, ReleaseBranchesConfiguration releaseBranchesConfiguration) {
        Optional<String> releasedTagName = this.release(rules, releaseBranchesConfiguration);
        if (releasedTagName.isEmpty()) {
            return new ScmPushResult(ScmPushResultOutcome.SKIPPED, Optional.empty(), Optional.empty());
        }
        ScmPushResult result = this.pushRelease();
        if (result.getOutcome().equals((Object)ScmPushResultOutcome.FAILED)) {
            releasedTagName.ifPresent(this::rollbackRelease);
        }
        return result;
    }

    public ScmPushResult pushRelease() {
        return this.repository.push();
    }

    private void rollbackRelease(String tagName) {
        logger.quiet("Removing tag: " + tagName);
        this.repository.dropTag(tagName);
        logger.quiet("Tag " + tagName + " removed");
    }
}

