/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import javax.inject.Inject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import pl.allegro.tech.build.axion.release.domain.BaseExtension;

public abstract class ChecksConfig
extends BaseExtension {
    private static final String DISABLE_UNCOMMITTED_CHANGES_CHECK = "release.disableUncommittedCheck";
    private static final String DISABLE_AHEAD_OF_REMOTE_CHECK = "release.disableRemoteCheck";
    private static final String DISABLE_SNAPSHOT_DEPENDENCIES_CHECK = "release.disableSnapshotsCheck";
    private static final String DISABLE_CHECKS = "release.disableChecks";

    @Input
    public abstract Property<Boolean> getAheadOfRemote();

    @Input
    public abstract Property<Boolean> getUncommittedChanges();

    @Input
    public abstract Property<Boolean> getSnapshotDependencies();

    @Inject
    public ChecksConfig() {
        this.getAheadOfRemote().convention((Object)true);
        this.getUncommittedChanges().convention((Object)true);
        this.getSnapshotDependencies().convention((Object)true);
    }

    public Provider<Boolean> checkUncommittedChanges() {
        return this.enabled(DISABLE_UNCOMMITTED_CHANGES_CHECK).orElse(this.getUncommittedChanges());
    }

    public Provider<Boolean> checkAheadOfRemote() {
        return this.enabled(DISABLE_AHEAD_OF_REMOTE_CHECK).orElse(this.getAheadOfRemote());
    }

    public Provider<Boolean> checkSnapshotDependencies() {
        return this.enabled(DISABLE_SNAPSHOT_DEPENDENCIES_CHECK).orElse(this.getSnapshotDependencies());
    }

    private Provider<Boolean> enabled(String property) {
        return this.gradlePropertyPresent(DISABLE_CHECKS).orElse(this.gradlePropertyPresent(property)).map(it -> false);
    }
}

