/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.hooks;

import java.util.Arrays;
import java.util.Optional;
import pl.allegro.tech.build.axion.release.domain.hooks.CommitHookAction;
import pl.allegro.tech.build.axion.release.domain.hooks.FileUpdateHookAction;
import pl.allegro.tech.build.axion.release.domain.hooks.PushHookAction;
import pl.allegro.tech.build.axion.release.domain.hooks.ReleaseHookFactory;
import pl.allegro.tech.build.axion.release.domain.hooks.SimpleReleaseHookAction;

public enum PredefinedReleaseHookAction {
    DEFAULT("default", new SimpleReleaseHookAction.Factory()),
    FILE_UPDATE("fileUpdate", new FileUpdateHookAction.Factory()),
    COMMIT("commit", new CommitHookAction.Factory()),
    PUSH("push", new PushHookAction.Factory());

    private final String type;
    private final ReleaseHookFactory factory;

    private PredefinedReleaseHookAction(String type, ReleaseHookFactory releaseHook) {
        this.type = type;
        this.factory = releaseHook;
    }

    public static ReleaseHookFactory factoryFor(String type) {
        Optional<PredefinedReleaseHookAction> factory = Arrays.stream(PredefinedReleaseHookAction.values()).filter(it -> it.type.equals(type)).findFirst();
        return factory.orElseThrow(() -> new IllegalArgumentException("There is no predefined release hook with " + type + " type. You can choose from: " + PredefinedReleaseHookAction.values())).getFactory();
    }

    public final ReleaseHookFactory getFactory() {
        return this.factory;
    }
}

