/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import javax.inject.Inject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.build.axion.release.domain.BaseExtension;
import pl.allegro.tech.build.axion.release.domain.NextVersionSerializer;
import pl.allegro.tech.build.axion.release.domain.properties.NextVersionProperties;

public abstract class NextVersionConfig
extends BaseExtension {
    private static final Logger logger = LoggerFactory.getLogger(NextVersionConfig.class);
    private static final String NEXT_VERSION_INCREMENTER_PROPERTY = "release.incrementer";
    private static final String NEXT_VERSION_PROPERTY = "release.version";
    private static final String DEPRECATED_NEXT_VERSION_PROPERTY = "release.nextVersion";

    @Inject
    public NextVersionConfig() {
        this.getSuffix().convention((Object)"alpha");
        this.getSeparator().convention((Object)"-");
        this.getSerializer().convention((Object)NextVersionSerializer.DEFAULT.serializer);
        this.getDeserializer().convention((Object)NextVersionSerializer.DEFAULT.deserializer);
    }

    @Input
    public abstract Property<String> getSuffix();

    @Input
    public abstract Property<String> getSeparator();

    @Internal
    public abstract Property<NextVersionProperties.Serializer> getSerializer();

    @Internal
    public abstract Property<NextVersionProperties.Deserializer> getDeserializer();

    public void serializer(String type) {
        this.getSerializer().set((Object)NextVersionSerializer.find((String)type).serializer);
    }

    public void deserializer(String type) {
        this.getDeserializer().set((Object)NextVersionSerializer.valueOf((String)type).deserializer);
    }

    public void serializer(NextVersionProperties.Serializer serializer) {
        this.getSerializer().set((Object)serializer);
    }

    public void deserializer(NextVersionProperties.Deserializer deserializer) {
        this.getDeserializer().set((Object)deserializer);
    }

    public NextVersionProperties nextVersionProperties() {
        if (((String)this.getSuffix().get()).isEmpty()) {
            String message = "scmVersion.nextVersion.suffix can't be empty! Empty suffix will prevent axion-release from distinguishing nextVersion from regular versions";
            throw new IllegalArgumentException(message);
        }
        return new NextVersionProperties((String)this.nextVersion().getOrNull(), (String)this.getSuffix().get(), (String)this.getSeparator().get(), (String)this.versionIncrementerName().getOrNull(), (NextVersionProperties.Serializer)this.getSerializer().get(), (NextVersionProperties.Deserializer)this.getDeserializer().get());
    }

    private Provider<String> versionIncrementerName() {
        return this.gradleProperty(NEXT_VERSION_INCREMENTER_PROPERTY);
    }

    private Provider<String> nextVersion() {
        return this.gradleProperty(NEXT_VERSION_PROPERTY).orElse(this.gradleProperty(DEPRECATED_NEXT_VERSION_PROPERTY).map(it -> {
            logger.warn("Using deprecated property: release.nextVersion! Use release.version instead.");
            return it;
        }));
    }
}

