/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.treewalk.filter;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.treewalk.TreeWalk;
import axion.org.eclipse.jgit.treewalk.WorkingTreeIterator;
import axion.org.eclipse.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;

public class NotIgnoredFilter
extends TreeFilter {
    private final int index;

    public NotIgnoredFilter(int workdirTreeIndex) {
        this.index = workdirTreeIndex;
    }

    @Override
    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        WorkingTreeIterator i = tw.getTree(this.index, WorkingTreeIterator.class);
        return i == null || !i.isEntryIgnored();
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "NotIgnored(" + this.index + ")";
    }
}

