/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.treewalk;

import axion.org.eclipse.jgit.dircache.DirCacheIterator;
import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.lib.FileMode;
import axion.org.eclipse.jgit.lib.ObjectReader;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import axion.org.eclipse.jgit.treewalk.EmptyTreeIterator;
import axion.org.eclipse.jgit.treewalk.WorkingTreeIterator;
import axion.org.eclipse.jgit.treewalk.WorkingTreeOptions;
import axion.org.eclipse.jgit.util.FS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;

public class FileTreeIterator
extends WorkingTreeIterator {
    protected final File directory;
    protected final FS fs;
    protected final FileModeStrategy fileModeStrategy;

    public FileTreeIterator(Repository repo) {
        this(repo, repo.getConfig().get(WorkingTreeOptions.KEY).isDirNoGitLinks() ? NoGitlinksStrategy.INSTANCE : DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator(Repository repo, FileModeStrategy fileModeStrategy) {
        this(repo.getWorkTree(), repo.getFS(), repo.getConfig().get(WorkingTreeOptions.KEY), fileModeStrategy);
        this.initRootIterator(repo);
    }

    public FileTreeIterator(File root, FS fs, WorkingTreeOptions options) {
        this(root, fs, options, (FileModeStrategy)DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator(File root, FS fs, WorkingTreeOptions options, FileModeStrategy fileModeStrategy) {
        super(options);
        this.directory = root;
        this.fs = fs;
        this.fileModeStrategy = fileModeStrategy;
        this.init(this.entries());
    }

    protected FileTreeIterator(FileTreeIterator p, File root, FS fs) {
        this(p, root, fs, p.fileModeStrategy);
    }

    protected FileTreeIterator(WorkingTreeIterator p, File root, FS fs, FileModeStrategy fileModeStrategy) {
        super(p);
        this.directory = root;
        this.fs = fs;
        this.fileModeStrategy = fileModeStrategy;
        this.init(this.entries());
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        DirCacheIterator iterator;
        if (!this.walksIgnoredDirectories() && this.isEntryIgnored() && (iterator = this.getDirCacheIterator()) == null) {
            return new EmptyTreeIterator(this);
        }
        return this.enterSubtree();
    }

    protected AbstractTreeIterator enterSubtree() {
        return new FileTreeIterator(this, ((FileEntry)this.current()).getFile(), this.fs, this.fileModeStrategy);
    }

    private WorkingTreeIterator.Entry[] entries() {
        return this.fs.list(this.directory, this.fileModeStrategy);
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getEntryFile() {
        return ((FileEntry)this.current()).getFile();
    }

    @Override
    protected byte[] idSubmodule(WorkingTreeIterator.Entry e) {
        return this.idSubmodule(this.getDirectory(), e);
    }

    @Override
    protected String readSymlinkTarget(WorkingTreeIterator.Entry entry) throws IOException {
        return this.fs.readSymLink(this.getEntryFile());
    }

    public static class DefaultFileModeStrategy
    implements FileModeStrategy {
        public static final DefaultFileModeStrategy INSTANCE = new DefaultFileModeStrategy();

        @Override
        public FileMode getMode(File f, FS.Attributes attributes) {
            if (attributes.isSymbolicLink()) {
                return FileMode.SYMLINK;
            }
            if (attributes.isDirectory()) {
                if (new File(f, ".git").exists()) {
                    return FileMode.GITLINK;
                }
                return FileMode.TREE;
            }
            if (attributes.isExecutable()) {
                return FileMode.EXECUTABLE_FILE;
            }
            return FileMode.REGULAR_FILE;
        }
    }

    public static class FileEntry
    extends WorkingTreeIterator.Entry {
        private final FileMode mode;
        private FS.Attributes attributes;
        private FS fs;

        public FileEntry(File f, FS fs) {
            this(f, fs, DefaultFileModeStrategy.INSTANCE);
        }

        public FileEntry(File f, FS fs, FileModeStrategy fileModeStrategy) {
            this.fs = fs;
            f = fs.normalize(f);
            this.attributes = fs.getAttributes(f);
            this.mode = fileModeStrategy.getMode(f, this.attributes);
        }

        public FileEntry(File f, FS fs, FS.Attributes attributes, FileModeStrategy fileModeStrategy) {
            this.fs = fs;
            this.attributes = attributes;
            f = fs.normalize(f);
            this.mode = fileModeStrategy.getMode(f, attributes);
        }

        @Override
        public FileMode getMode() {
            return this.mode;
        }

        @Override
        public String getName() {
            return this.attributes.getName();
        }

        @Override
        public long getLength() {
            return this.attributes.getLength();
        }

        @Override
        @Deprecated
        public long getLastModified() {
            return this.attributes.getLastModifiedInstant().toEpochMilli();
        }

        @Override
        public Instant getLastModifiedInstant() {
            return this.attributes.getLastModifiedInstant();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.attributes.isSymbolicLink()) {
                return new ByteArrayInputStream(this.fs.readSymLink(this.getFile()).getBytes(StandardCharsets.UTF_8));
            }
            return new FileInputStream(this.getFile());
        }

        public File getFile() {
            return this.attributes.getFile();
        }
    }

    public static interface FileModeStrategy {
        public FileMode getMode(File var1, FS.Attributes var2);
    }

    public static class NoGitlinksStrategy
    implements FileModeStrategy {
        public static final NoGitlinksStrategy INSTANCE = new NoGitlinksStrategy();

        @Override
        public FileMode getMode(File f, FS.Attributes attributes) {
            if (attributes.isSymbolicLink()) {
                return FileMode.SYMLINK;
            }
            if (attributes.isDirectory()) {
                return FileMode.TREE;
            }
            if (attributes.isExecutable()) {
                return FileMode.EXECUTABLE_FILE;
            }
            return FileMode.REGULAR_FILE;
        }
    }
}

