/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.transport;

import axion.com.jcraft.jsch.Channel;
import axion.com.jcraft.jsch.ChannelExec;
import axion.com.jcraft.jsch.ChannelSftp;
import axion.com.jcraft.jsch.JSchException;
import axion.com.jcraft.jsch.Session;
import axion.com.jcraft.jsch.SftpException;
import axion.org.eclipse.jgit.errors.TransportException;
import axion.org.eclipse.jgit.internal.transport.jsch.JSchText;
import axion.org.eclipse.jgit.transport.FtpChannel;
import axion.org.eclipse.jgit.transport.RemoteSession2;
import axion.org.eclipse.jgit.transport.URIish;
import axion.org.eclipse.jgit.util.io.IsolatedOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class JschSession
implements RemoteSession2 {
    final Session sock;
    final URIish uri;

    public JschSession(Session session, URIish uri) {
        this.sock = session;
        this.uri = uri;
    }

    @Override
    public Process exec(String command, int timeout) throws IOException {
        return this.exec(command, Collections.emptyMap(), timeout);
    }

    @Override
    public Process exec(String command, Map<String, String> environment, int timeout) throws IOException {
        return new JschProcess(command, environment, timeout);
    }

    @Override
    public void disconnect() {
        if (this.sock.isConnected()) {
            this.sock.disconnect();
        }
    }

    @Deprecated
    public Channel getSftpChannel() throws JSchException {
        return this.sock.openChannel("sftp");
    }

    @Override
    public FtpChannel getFtpChannel() {
        return new JschFtpChannel();
    }

    private class JschFtpChannel
    implements FtpChannel {
        private ChannelSftp ftp;

        private JschFtpChannel() {
        }

        @Override
        public void connect(int timeout, TimeUnit unit) throws IOException {
            try {
                this.ftp = (ChannelSftp)JschSession.this.sock.openChannel("sftp");
                this.ftp.connect((int)unit.toMillis(timeout));
            }
            catch (JSchException e) {
                this.ftp = null;
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public void disconnect() {
            this.ftp.disconnect();
            this.ftp = null;
        }

        private <T> T map(Callable<T> op) throws IOException {
            try {
                return op.call();
            }
            catch (Exception e) {
                if (e instanceof SftpException) {
                    throw new FtpChannel.FtpException(e.getLocalizedMessage(), ((SftpException)e).id, e);
                }
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public boolean isConnected() {
            return this.ftp != null && JschSession.this.sock.isConnected();
        }

        @Override
        public void cd(String path) throws IOException {
            this.map(() -> {
                this.ftp.cd(path);
                return null;
            });
        }

        @Override
        public String pwd() throws IOException {
            return this.map(() -> this.ftp.pwd());
        }

        @Override
        public Collection<FtpChannel.DirEntry> ls(String path) throws IOException {
            return this.map(() -> {
                ArrayList<2> result = new ArrayList<2>();
                for (Object e : this.ftp.ls(path)) {
                    final ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)e;
                    result.add(new FtpChannel.DirEntry(){

                        @Override
                        public String getFilename() {
                            return entry.getFilename();
                        }

                        @Override
                        public long getModifiedTime() {
                            return entry.getAttrs().getMTime();
                        }

                        @Override
                        public boolean isDirectory() {
                            return entry.getAttrs().isDir();
                        }
                    });
                }
                return result;
            });
        }

        @Override
        public void rmdir(String path) throws IOException {
            this.map(() -> {
                this.ftp.rm(path);
                return null;
            });
        }

        @Override
        public void mkdir(String path) throws IOException {
            this.map(() -> {
                this.ftp.mkdir(path);
                return null;
            });
        }

        @Override
        public InputStream get(String path) throws IOException {
            return this.map(() -> this.ftp.get(path));
        }

        @Override
        public OutputStream put(String path) throws IOException {
            return this.map(() -> this.ftp.put(path));
        }

        @Override
        public void rm(String path) throws IOException {
            this.map(() -> {
                this.ftp.rm(path);
                return null;
            });
        }

        @Override
        public void rename(String from, String to) throws IOException {
            this.map(() -> {
                if (this.hasPosixRename()) {
                    this.ftp.rename(from, to);
                } else if (!to.equals(from)) {
                    this.delete(to);
                    this.ftp.rename(from, to);
                }
                return null;
            });
        }

        private boolean hasPosixRename() {
            return "1".equals(this.ftp.getExtension("posix-rename@openssh.com"));
        }
    }

    private class JschProcess
    extends Process {
        private ChannelExec channel;
        final int timeout;
        private InputStream inputStream;
        private OutputStream outputStream;
        private InputStream errStream;

        JschProcess(String commandName, Map<String, String> environment, int tms) throws TransportException, IOException {
            this.timeout = tms;
            try {
                this.channel = (ChannelExec)JschSession.this.sock.openChannel("exec");
                if (environment != null) {
                    for (Map.Entry<String, String> envVar : environment.entrySet()) {
                        this.channel.setEnv(envVar.getKey(), envVar.getValue());
                    }
                }
                this.channel.setCommand(commandName);
                this.setupStreams();
                this.channel.connect(this.timeout > 0 ? this.timeout * 1000 : 0);
                if (!this.channel.isConnected()) {
                    this.closeOutputStream();
                    throw new TransportException(JschSession.this.uri, JSchText.get().connectionFailed);
                }
            }
            catch (JSchException e) {
                this.closeOutputStream();
                throw new TransportException(JschSession.this.uri, e.getMessage(), e);
            }
        }

        private void closeOutputStream() {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void setupStreams() throws IOException {
            this.inputStream = this.channel.getInputStream();
            OutputStream out = this.channel.getOutputStream();
            if (this.timeout <= 0) {
                this.outputStream = out;
            } else {
                IsolatedOutputStream i = new IsolatedOutputStream(out);
                this.outputStream = new BufferedOutputStream(i, 16384);
            }
            this.errStream = this.channel.getErrStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public InputStream getErrorStream() {
            return this.errStream;
        }

        @Override
        public int exitValue() {
            if (this.isRunning()) {
                throw new IllegalThreadStateException();
            }
            return this.channel.getExitStatus();
        }

        private boolean isRunning() {
            return this.channel.getExitStatus() < 0 && this.channel.isConnected();
        }

        @Override
        public void destroy() {
            if (this.channel.isConnected()) {
                this.channel.disconnect();
            }
            this.closeOutputStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            while (this.isRunning()) {
                Thread.sleep(100L);
            }
            return this.exitValue();
        }
    }
}

