/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.revwalk;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.revwalk.AbstractRevQueue;
import axion.org.eclipse.jgit.revwalk.BoundaryGenerator;
import axion.org.eclipse.jgit.revwalk.DateRevQueue;
import axion.org.eclipse.jgit.revwalk.DelayRevQueue;
import axion.org.eclipse.jgit.revwalk.DepthGenerator;
import axion.org.eclipse.jgit.revwalk.DepthWalk;
import axion.org.eclipse.jgit.revwalk.FIFORevQueue;
import axion.org.eclipse.jgit.revwalk.FixUninterestingGenerator;
import axion.org.eclipse.jgit.revwalk.Generator;
import axion.org.eclipse.jgit.revwalk.LIFORevQueue;
import axion.org.eclipse.jgit.revwalk.MergeBaseGenerator;
import axion.org.eclipse.jgit.revwalk.ObjectWalk;
import axion.org.eclipse.jgit.revwalk.PendingGenerator;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevSort;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import axion.org.eclipse.jgit.revwalk.RewriteGenerator;
import axion.org.eclipse.jgit.revwalk.TopoNonIntermixSortGenerator;
import axion.org.eclipse.jgit.revwalk.TopoSortGenerator;
import axion.org.eclipse.jgit.revwalk.TreeRevFilter;
import axion.org.eclipse.jgit.revwalk.filter.AndRevFilter;
import axion.org.eclipse.jgit.revwalk.filter.RevFilter;
import axion.org.eclipse.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.text.MessageFormat;

class StartGenerator
extends Generator {
    private final RevWalk walker;

    StartGenerator(RevWalk w) {
        super(w.isFirstParent());
        this.walker = w;
    }

    @Override
    int outputType() {
        return 0;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Generator g;
        RevWalk w = this.walker;
        RevFilter rf = w.getRevFilter();
        TreeFilter tf = w.getTreeFilter();
        AbstractRevQueue q = this.walker.queue;
        if (rf == RevFilter.MERGE_BASE) {
            if (tf != TreeFilter.ALL) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().cannotCombineTreeFilterWithRevFilter, tf, rf));
            }
            if (w.isFirstParent()) {
                throw new IllegalStateException(JGitText.get().cannotFindMergeBaseUsingFirstParent);
            }
            MergeBaseGenerator mbg = new MergeBaseGenerator(w);
            this.walker.pending = mbg;
            this.walker.queue = AbstractRevQueue.EMPTY_QUEUE;
            mbg.init(q);
            return mbg.next();
        }
        boolean uninteresting = q.anybodyHasFlag(4);
        boolean boundary = this.walker.hasRevSort(RevSort.BOUNDARY);
        if (!boundary && this.walker instanceof ObjectWalk) {
            boundary = true;
        }
        if (boundary && !uninteresting) {
            boundary = false;
        }
        int pendingOutputType = 0;
        DateRevQueue pending = q instanceof DateRevQueue ? (DateRevQueue)q : new DateRevQueue(q);
        if (tf != TreeFilter.ALL) {
            int rewriteFlag;
            if (w.getRewriteParents()) {
                pendingOutputType |= 6;
                rewriteFlag = 8;
            } else {
                rewriteFlag = 0;
            }
            rf = AndRevFilter.create(new TreeRevFilter(w, tf, rewriteFlag), rf);
        }
        this.walker.queue = q;
        if (this.walker instanceof DepthWalk) {
            DepthWalk dw = (DepthWalk)((Object)this.walker);
            g = new DepthGenerator(dw, pending);
        } else {
            g = new PendingGenerator(w, pending, rf, pendingOutputType);
            if (this.walker.hasRevSort(RevSort.BOUNDARY)) {
                ((PendingGenerator)g).canDispose = false;
            }
        }
        if ((g.outputType() & 4) != 0) {
            g = new FIFORevQueue(g);
            g = new RewriteGenerator(g);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && this.walker.hasRevSort(RevSort.TOPO_KEEP_BRANCH_TOGETHER)) {
            throw new IllegalStateException(JGitText.get().cannotCombineTopoSortWithTopoKeepBranchTogetherSort);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && (g.outputType() & 8) == 0) {
            g = new TopoSortGenerator(g);
        } else if (this.walker.hasRevSort(RevSort.TOPO_KEEP_BRANCH_TOGETHER) && (g.outputType() & 8) == 0) {
            g = new TopoNonIntermixSortGenerator(g);
        }
        if (this.walker.hasRevSort(RevSort.REVERSE)) {
            g = new LIFORevQueue(g);
        }
        if (boundary) {
            g = new BoundaryGenerator(w, g);
        } else if (uninteresting) {
            if (pending.peek() != null) {
                g = new DelayRevQueue(g);
            }
            g = new FixUninterestingGenerator(g);
        }
        w.pending = g;
        return g.next();
    }
}

