/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.transport.sshd;

import axion.org.apache.sshd.client.auth.keyboard.UserInteraction;
import axion.org.apache.sshd.client.auth.password.UserAuthPassword;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.core.CoreModuleProperties;
import axion.org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import axion.org.eclipse.jgit.internal.transport.sshd.SshdText;

public class JGitPasswordAuthentication
extends UserAuthPassword {
    private int maxAttempts;
    private int attempts;

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.maxAttempts = Math.max(1, CoreModuleProperties.PASSWORD_PROMPTS.getRequired(session));
        this.attempts = 0;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        if (++this.attempts > this.maxAttempts) {
            return false;
        }
        UserInteraction interaction = session.getUserInteraction();
        if (!interaction.isInteractionAllowed(session)) {
            return false;
        }
        String password = this.getPassword(session, interaction);
        if (password == null) {
            throw new AuthenticationCanceledException();
        }
        this.sendPassword(null, session, password, password);
        return true;
    }

    private String getPassword(ClientSession session, UserInteraction interaction) {
        String[] results = interaction.interactive(session, null, null, "", new String[]{SshdText.get().passwordPrompt}, new boolean[1]);
        return results == null || results.length == 0 ? null : results[0];
    }
}

