/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.revwalk;

import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import axion.org.eclipse.jgit.revwalk.ObjectWalk;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevObject;
import axion.org.eclipse.jgit.revwalk.RevSort;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

public class PedestrianObjectReachabilityChecker
implements ObjectReachabilityChecker {
    private final ObjectWalk walk;

    public PedestrianObjectReachabilityChecker(ObjectWalk walk) {
        this.walk = walk;
    }

    @Override
    public Optional<RevObject> areAllReachable(Collection<RevObject> targets, Stream<RevObject> starters) throws IOException {
        try {
            this.walk.reset();
            this.walk.sort(RevSort.TOPO);
            for (RevObject target : targets) {
                this.walk.markStart(target);
            }
            Iterator iterator = starters.iterator();
            while (iterator.hasNext()) {
                RevObject o = (RevObject)iterator.next();
                this.walk.markUninteresting(o);
                RevObject peeled = this.walk.peel(o);
                if (!(peeled instanceof RevCommit)) continue;
                this.walk.markUninteresting(((RevCommit)peeled).getTree());
            }
            RevCommit commit = this.walk.next();
            if (commit != null) {
                return Optional.of(commit);
            }
            RevObject object = this.walk.nextObject();
            if (object != null) {
                return Optional.of(object);
            }
            return Optional.empty();
        }
        catch (MissingObjectException | InvalidObjectException e) {
            throw new IllegalStateException(e);
        }
    }
}

