/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.api;

import axion.org.eclipse.jgit.api.GitCommand;
import axion.org.eclipse.jgit.api.errors.GitAPIException;
import axion.org.eclipse.jgit.api.errors.JGitInternalException;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.lib.StoredConfig;
import axion.org.eclipse.jgit.transport.RemoteConfig;
import axion.org.eclipse.jgit.transport.URIish;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class RemoteSetUrlCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;
    private URIish remoteUri;
    private UriType type;

    protected RemoteSetUrlCommand(Repository repo) {
        super(repo);
    }

    @Deprecated
    public void setName(String name) {
        this.remoteName = name;
    }

    public RemoteSetUrlCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    @Deprecated
    public void setUri(URIish uri) {
        this.remoteUri = uri;
    }

    public RemoteSetUrlCommand setRemoteUri(URIish remoteUri) {
        this.remoteUri = remoteUri;
        return this;
    }

    @Deprecated
    public void setPush(boolean push) {
        if (push) {
            this.setUriType(UriType.PUSH);
        } else {
            this.setUriType(UriType.FETCH);
        }
    }

    public RemoteSetUrlCommand setUriType(UriType type) {
        this.type = type;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.remoteName);
            if (this.type == UriType.PUSH) {
                List<URIish> uris = remote.getPushURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.pushurl has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removePushURI(uris.get(0));
                }
                remote.addPushURI(this.remoteUri);
            } else {
                List<URIish> uris = remote.getURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.url has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removeURI(uris.get(0));
                }
                remote.addURI(this.remoteUri);
            }
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public static enum UriType {
        FETCH,
        PUSH;

    }
}

