/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.pkcs.bc;

import axion.org.bouncycastle.asn1.DERNull;
import axion.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.operator.MacCalculator;
import axion.org.bouncycastle.operator.OperatorCreationException;
import axion.org.bouncycastle.operator.bc.BcDigestProvider;
import axion.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import axion.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import axion.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider bcDigestProvider) {
        this.digestProvider = bcDigestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pKCS12PBEParams, cArray);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

