/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.operator.bc;

import axion.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.crypto.AsymmetricBlockCipher;
import axion.org.bouncycastle.crypto.CipherParameters;
import axion.org.bouncycastle.crypto.InvalidCipherTextException;
import axion.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import axion.org.bouncycastle.crypto.params.ParametersWithRandom;
import axion.org.bouncycastle.operator.AsymmetricKeyWrapper;
import axion.org.bouncycastle.operator.GenericKey;
import axion.org.bouncycastle.operator.OperatorException;
import axion.org.bouncycastle.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier);
        this.publicKey = asymmetricKeyParameter;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters cipherParameters = this.publicKey;
        if (this.random != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
        }
        try {
            byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
            asymmetricBlockCipher.init(true, cipherParameters);
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to encrypt contents key", invalidCipherTextException);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

