/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.operator.bc;

import axion.org.bouncycastle.crypto.BlockCipher;
import axion.org.bouncycastle.crypto.BufferedBlockCipher;
import axion.org.bouncycastle.crypto.InvalidCipherTextException;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import axion.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import axion.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import axion.org.bouncycastle.openpgp.operator.bc.BcUtil;
import axion.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import java.security.SecureRandom;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
            BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(true, blockCipher, byArray, new byte[blockCipher.getBlockSize()]);
            byte[] byArray3 = new byte[byArray2.length];
            int n2 = bufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
            n2 += bufferedBlockCipher.doFinal(byArray3, n2);
            return byArray3;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("encryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

