/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp;

import axion.org.bouncycastle.apache.bzip2.CBZip2OutputStream;
import axion.org.bouncycastle.bcpg.BCPGOutputStream;
import axion.org.bouncycastle.bcpg.CompressionAlgorithmTags;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.StreamGenerator;
import axion.org.bouncycastle.openpgp.WrappedGeneratorStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PGPCompressedDataGenerator
implements CompressionAlgorithmTags,
StreamGenerator {
    private int algorithm;
    private int compression;
    private OutputStream dOut;
    private BCPGOutputStream pkOut;

    public PGPCompressedDataGenerator(int n) {
        this(n, -1);
    }

    public PGPCompressedDataGenerator(int n, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown compression algorithm");
            }
        }
        if (n2 != -1 && (n2 < 0 || n2 > 9)) {
            throw new IllegalArgumentException("unknown compression level: " + n2);
        }
        this.algorithm = n;
        this.compression = n2;
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream, 8);
        this.doOpen();
        return new WrappedGeneratorStream(this.dOut, this);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
        this.doOpen();
        return new WrappedGeneratorStream(this.dOut, this);
    }

    private void doOpen() throws IOException {
        this.pkOut.write(this.algorithm);
        switch (this.algorithm) {
            case 0: {
                this.dOut = this.pkOut;
                break;
            }
            case 1: {
                this.dOut = new SafeDeflaterOutputStream(this.pkOut, this.compression, true);
                break;
            }
            case 2: {
                this.dOut = new SafeDeflaterOutputStream(this.pkOut, this.compression, false);
                break;
            }
            case 3: {
                this.dOut = new SafeCBZip2OutputStream(this.pkOut);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void close() throws IOException {
        if (this.dOut != null) {
            if (this.dOut != this.pkOut) {
                this.dOut.close();
            }
            this.dOut = null;
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }

    private static class SafeCBZip2OutputStream
    extends CBZip2OutputStream {
        public SafeCBZip2OutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        public void close() throws IOException {
            this.finish();
        }
    }

    private class SafeDeflaterOutputStream
    extends DeflaterOutputStream {
        public SafeDeflaterOutputStream(OutputStream outputStream, int n, boolean bl) {
            super(outputStream, new Deflater(n, bl));
        }

        public void close() throws IOException {
            this.finish();
            this.def.end();
        }
    }
}

