/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.dvcs;

import axion.org.bouncycastle.asn1.dvcs.CertEtcToken;
import axion.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import axion.org.bouncycastle.asn1.dvcs.DVCSTime;
import axion.org.bouncycastle.asn1.dvcs.Data;
import axion.org.bouncycastle.asn1.dvcs.ServiceType;
import axion.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import axion.org.bouncycastle.asn1.x509.Extension;
import axion.org.bouncycastle.cert.X509CertificateHolder;
import axion.org.bouncycastle.dvcs.DVCSException;
import axion.org.bouncycastle.dvcs.DVCSRequest;
import axion.org.bouncycastle.dvcs.DVCSRequestBuilder;
import axion.org.bouncycastle.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder x509CertificateHolder) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, x509CertificateHolder.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

