/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.crypto.parsers;

import axion.org.bouncycastle.crypto.KeyParser;
import axion.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import axion.org.bouncycastle.crypto.params.DHParameters;
import axion.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import axion.org.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DHIESPublicKeyParser
implements KeyParser {
    private DHParameters dhParams;

    public DHIESPublicKeyParser(DHParameters dHParameters) {
        this.dhParams = dHParameters;
    }

    public AsymmetricKeyParameter readKey(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[(this.dhParams.getP().bitLength() + 7) / 8];
        Streams.readFully(inputStream, byArray, 0, byArray.length);
        return new DHPublicKeyParameters(new BigInteger(1, byArray), this.dhParams);
    }
}

