/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.cms;

import axion.org.bouncycastle.asn1.ASN1OctetString;
import axion.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import axion.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import axion.org.bouncycastle.asn1.cms.RecipientIdentifier;
import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.cms.AuthAttributesProvider;
import axion.org.bouncycastle.cms.CMSException;
import axion.org.bouncycastle.cms.CMSSecureReadable;
import axion.org.bouncycastle.cms.KeyTransRecipient;
import axion.org.bouncycastle.cms.KeyTransRecipientId;
import axion.org.bouncycastle.cms.Recipient;
import axion.org.bouncycastle.cms.RecipientInformation;
import axion.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

