/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.cms;

import axion.org.bouncycastle.asn1.cms.KEKIdentifier;
import axion.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.cms.AuthAttributesProvider;
import axion.org.bouncycastle.cms.CMSException;
import axion.org.bouncycastle.cms.CMSSecureReadable;
import axion.org.bouncycastle.cms.KEKRecipient;
import axion.org.bouncycastle.cms.KEKRecipientId;
import axion.org.bouncycastle.cms.Recipient;
import axion.org.bouncycastle.cms.RecipientInformation;
import axion.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

