/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.bcpg;

import axion.org.bouncycastle.bcpg.BCPGInputStream;
import axion.org.bouncycastle.bcpg.BCPGKey;
import axion.org.bouncycastle.bcpg.BCPGObject;
import axion.org.bouncycastle.bcpg.BCPGOutputStream;
import axion.org.bouncycastle.bcpg.MPInteger;
import java.io.IOException;
import java.math.BigInteger;

public class RSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger n;
    MPInteger e;

    public RSAPublicBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.n = new MPInteger(bCPGInputStream);
        this.e = new MPInteger(bCPGInputStream);
    }

    public RSAPublicBCPGKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n = new MPInteger(bigInteger);
        this.e = new MPInteger(bigInteger2);
    }

    public BigInteger getPublicExponent() {
        return this.e.getValue();
    }

    public BigInteger getModulus() {
        return this.n.getValue();
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writeObject(this.n);
        bCPGOutputStream.writeObject(this.e);
    }
}

