/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.client.impl;

import axion.org.apache.sshd.client.channel.ChannelSubsystem;
import axion.org.apache.sshd.client.channel.ClientChannel;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.SshException;
import axion.org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import axion.org.apache.sshd.common.future.CloseFuture;
import axion.org.apache.sshd.common.io.IoOutputStream;
import axion.org.apache.sshd.common.io.IoWriteFuture;
import axion.org.apache.sshd.common.session.ConnectionService;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import axion.org.apache.sshd.common.util.io.NullOutputStream;
import axion.org.apache.sshd.core.CoreModuleProperties;
import axion.org.apache.sshd.sftp.SftpModuleProperties;
import axion.org.apache.sshd.sftp.client.SftpVersionSelector;
import axion.org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import axion.org.apache.sshd.sftp.common.SftpConstants;
import axion.org.apache.sshd.sftp.common.extensions.ParserUtils;
import axion.org.apache.sshd.sftp.common.extensions.VersionsParser;
import axion.org.apache.sshd.sftp.server.SftpSubsystemEnvironment;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultSftpClient
extends AbstractSftpClient {
    private final ClientSession clientSession;
    private final ChannelSubsystem channel;
    private final Map<Integer, Buffer> messages = new HashMap<Integer, Buffer>();
    private final AtomicInteger cmdId = new AtomicInteger(100);
    private final Buffer receiveBuffer = new ByteArrayBuffer();
    private final AtomicInteger versionHolder = new AtomicInteger(0);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final NavigableMap<String, byte[]> extensions = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
    private final NavigableMap<String, byte[]> exposedExtensions = Collections.unmodifiableNavigableMap(this.extensions);
    private Charset nameDecodingCharset;

    public DefaultSftpClient(ClientSession clientSession, SftpVersionSelector initialVersionSelector) throws IOException {
        this.nameDecodingCharset = SftpModuleProperties.NAME_DECODING_CHARSET.getRequired(clientSession);
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.channel = this.createSftpChannelSubsystem(clientSession);
        clientSession.getService(ConnectionService.class).registerChannel(this.channel);
        Duration initializationTimeout = SftpModuleProperties.SFTP_CHANNEL_OPEN_TIMEOUT.getRequired(clientSession);
        this.channel.open().verify(initializationTimeout);
        this.channel.onClose(() -> {
            Map<Integer, Buffer> map = this.messages;
            synchronized (map) {
                this.closing.set(true);
                this.messages.notifyAll();
            }
            if (this.versionHolder.get() <= 0) {
                this.log.warn("onClose({}) closed before version negotiated", (Object)this.channel);
            }
        });
        try {
            this.init(clientSession, initialVersionSelector, initializationTimeout);
        }
        catch (IOException | Error | RuntimeException e) {
            this.channel.close(true);
            throw e;
        }
    }

    @Override
    public int getVersion() {
        return this.versionHolder.get();
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public ClientChannel getClientChannel() {
        return this.channel;
    }

    @Override
    public NavigableMap<String, byte[]> getServerExtensions() {
        return this.exposedExtensions;
    }

    @Override
    public Charset getNameDecodingCharset() {
        return this.nameDecodingCharset;
    }

    @Override
    public void setNameDecodingCharset(Charset nameDecodingCharset) {
        this.nameDecodingCharset = Objects.requireNonNull(nameDecodingCharset, "No charset provided");
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close(false);
        }
    }

    protected int data(byte[] buf, int start, int len) throws IOException {
        Buffer incoming = new ByteArrayBuffer(buf, start, len);
        if (this.receiveBuffer.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
            incoming = this.receiveBuffer;
        }
        int rpos = incoming.rpos();
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (this.receive(incoming)) {
            if (traceEnabled) {
                this.log.trace("data({}) Processed {} data messages", (Object)this.getClientChannel(), (Object)count);
            }
            ++count;
        }
        int read = incoming.rpos() - rpos;
        this.receiveBuffer.compact();
        if (this.receiveBuffer != incoming && incoming.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
        }
        return read;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        ClientSession session = this.getClientSession();
        session.resetIdleTimeout();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (length > 262144) {
                throw new StreamCorruptedException("Illogical sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Buffer incoming) throws IOException {
        ByteArrayBuffer buffer = new ByteArrayBuffer(incoming.available() + 64, false);
        buffer.putBuffer(incoming);
        int rpos = ((Buffer)buffer).rpos();
        int length = buffer.getInt();
        int type = buffer.getUByte();
        Integer id = buffer.getInt();
        ((Buffer)buffer).rpos(rpos);
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) id={}, type={}, len={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(type), length});
        }
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            this.messages.put(id, buffer);
            this.messages.notifyAll();
        }
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        Buffer buf;
        int id = this.cmdId.incrementAndGet();
        int len = buffer.available();
        if (this.log.isTraceEnabled()) {
            this.log.trace("send({}) cmd={}, len={}, id={}", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(cmd), len, id});
        }
        int hdr = 9;
        if (buffer.rpos() >= hdr) {
            int wpos = buffer.wpos();
            int s = buffer.rpos() - hdr;
            buffer.rpos(s);
            buffer.wpos(s);
            buffer.putInt(5 + len);
            buffer.putByte((byte)(cmd & 0xFF));
            buffer.putInt(id);
            buffer.wpos(wpos);
            buf = buffer;
        } else {
            buf = new ByteArrayBuffer(hdr + len);
            buf.putInt(5 + len);
            ((Buffer)buf).putByte((byte)(cmd & 0xFF));
            buf.putInt(id);
            buf.putBuffer(buffer);
        }
        IoOutputStream asyncIn = this.channel.getAsyncIn();
        IoWriteFuture writeFuture = asyncIn.writeBuffer(buf);
        writeFuture.verify();
        return id;
    }

    @Override
    public Buffer receive(int id) throws IOException {
        ClientSession session = this.getClientSession();
        Duration idleTimeout = CoreModuleProperties.IDLE_TIMEOUT.getRequired(session);
        if (GenericUtils.isNegativeOrNull(idleTimeout)) {
            idleTimeout = CoreModuleProperties.IDLE_TIMEOUT.getRequiredDefault();
        }
        Instant now = Instant.now();
        Instant waitEnd = now.plus(idleTimeout);
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (true) {
            if (this.isClosing() || !this.isOpen()) {
                throw new SshException("Channel is being closed");
            }
            if (now.compareTo(waitEnd) > 0) {
                throw new SshException("Timeout expired while waiting for id=" + id);
            }
            Buffer buffer = this.receive(id, Duration.between(now, waitEnd));
            if (buffer != null) {
                return buffer;
            }
            now = Instant.now();
            if (traceEnabled) {
                this.log.trace("receive({}) check iteration #{} for id={} remain time={}", new Object[]{this, count, id, idleTimeout});
            }
            ++count;
        }
    }

    @Override
    public Buffer receive(int id, long idleTimeout) throws IOException {
        return this.receive(id, Duration.ofMillis(idleTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer receive(int id, Duration idleTimeout) throws IOException {
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            Buffer buffer = this.messages.remove(id);
            if (buffer != null) {
                return buffer;
            }
            if (GenericUtils.isPositive(idleTimeout)) {
                try {
                    this.messages.wait(idleTimeout.toMillis(), idleTimeout.getNano() % 1000000);
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted while waiting for messages").initCause(e);
                }
            }
        }
        return null;
    }

    protected void init(ClientSession session, SftpVersionSelector initialVersionSelector, Duration initializationTimeout) throws IOException {
        int initialVersion = initialVersionSelector == null ? 6 : initialVersionSelector.selectVersion(session, true, 6, SftpSubsystemEnvironment.SUPPORTED_SFTP_VERSIONS);
        ValidateUtils.checkState(SftpSubsystemEnvironment.SUPPORTED_SFTP_VERSIONS.contains(initialVersion), "Unsupported initial version selected: %d", initialVersion);
        ByteArrayBuffer buf = new ByteArrayBuffer(10);
        buf.putInt(5L);
        ((Buffer)buf).putByte((byte)1);
        buf.putInt(initialVersion);
        boolean traceEnabled = this.log.isTraceEnabled();
        IoOutputStream asyncIn = this.channel.getAsyncIn();
        ClientChannel clientChannel = this.getClientChannel();
        if (traceEnabled) {
            this.log.trace("init({}) send SSH_FXP_INIT - initial version={}", (Object)clientChannel, (Object)initialVersion);
        }
        IoWriteFuture writeFuture = asyncIn.writeBuffer(buf);
        writeFuture.verify();
        if (traceEnabled) {
            this.log.trace("init({}) wait for SSH_FXP_INIT respose (timeout={})", (Object)clientChannel, (Object)initializationTimeout);
        }
        Buffer buffer = this.waitForInitResponse(initializationTimeout);
        this.handleInitResponse(buffer);
    }

    protected void handleInitResponse(Buffer buffer) throws IOException {
        boolean traceEnabled = this.log.isTraceEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (traceEnabled) {
            this.log.trace("handleInitResponse({}) id={} type={} len={}", new Object[]{clientChannel, id, SftpConstants.getCommandMessageName(type), length});
        }
        if (type == 2) {
            if (id < 3 || id > 6) {
                throw new SshException("Unsupported sftp version " + id);
            }
            this.versionHolder.set(id);
            if (traceEnabled) {
                this.log.trace("handleInitResponse({}) version={}", (Object)clientChannel, (Object)this.versionHolder);
            }
            while (buffer.available() > 0) {
                String name = buffer.getString();
                byte[] data = buffer.getBytes();
                if (traceEnabled) {
                    this.log.trace("handleInitResponse({}) added extension={}", (Object)clientChannel, (Object)name);
                }
                this.extensions.put(name, data);
            }
        } else if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (traceEnabled) {
                this.log.trace("handleInitResponse({})[id={}] - status: {} [{}] {}", new Object[]{clientChannel, id, SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(1, id, substatus, msg, lang);
        } else {
            IOException err = this.handleUnexpectedPacket(1, 2, id, type, length, buffer);
            if (err != null) {
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer waitForInitResponse(Duration initializationTimeout) throws IOException {
        ValidateUtils.checkTrue(GenericUtils.isPositive(initializationTimeout), "Invalid initialization timeout: %d", (Object)initializationTimeout);
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            Instant now = Instant.now();
            Instant max = now.plus(initializationTimeout);
            while (now.compareTo(max) < 0 && this.messages.isEmpty() && !this.isClosing() && this.isOpen()) {
                try {
                    Duration rem = Duration.between(now, max);
                    this.messages.wait(rem.toMillis(), rem.getNano() % 1000000);
                    now = Instant.now();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted init() while " + Duration.between(now, max) + " remaining").initCause(e);
                }
            }
            if (this.isClosing() || !this.isOpen()) {
                throw new EOFException("Closing while await init message");
            }
            if (this.messages.isEmpty()) {
                throw new SocketTimeoutException("No incoming initialization response received within " + initializationTimeout + " msec.");
            }
            Set<Integer> ids = this.messages.keySet();
            Iterator iter = ids.iterator();
            Integer reqId = (Integer)iter.next();
            return this.messages.remove(reqId);
        }
    }

    public int negotiateVersion(SftpVersionSelector selector) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int current = this.getVersion();
        if (selector == null) {
            if (debugEnabled) {
                this.log.debug("negotiateVersion({}) no selector to override current={}", (Object)clientChannel, (Object)current);
            }
            return current;
        }
        Map<String, Object> parsed = this.getParsedServerExtensions();
        Set<String> extensions = ParserUtils.supportedExtensions(parsed);
        List<Integer> availableVersions = Collections.emptyList();
        if (GenericUtils.size(extensions) > 0 && extensions.contains("version-select")) {
            VersionsParser.Versions vers = GenericUtils.isEmpty(parsed) ? null : (VersionsParser.Versions)parsed.get("versions");
            availableVersions = vers == null ? Collections.singletonList(current) : vers.resolveAvailableVersions(current);
        } else {
            availableVersions = Collections.singletonList(current);
        }
        ClientSession session = this.getClientSession();
        int selected = selector.selectVersion(session, false, current, availableVersions);
        if (debugEnabled) {
            this.log.debug("negotiateVersion({}) current={} {} -> {}", new Object[]{clientChannel, current, availableVersions, selected});
        }
        if (selected == current) {
            return current;
        }
        if (!availableVersions.contains(selected)) {
            throw new StreamCorruptedException("Selected version (" + selected + ") not part of available: " + availableVersions);
        }
        String verVal = String.valueOf(selected);
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + "version-select".length() + 4 + verVal.length() + 8, false);
        buffer.putString("version-select");
        buffer.putString(verVal);
        this.checkCommandStatus(200, buffer);
        this.versionHolder.set(selected);
        return selected;
    }

    protected ChannelSubsystem createSftpChannelSubsystem(ClientSession clientSession) {
        return new SftpChannelSubsystem();
    }

    protected class SftpChannelSubsystem
    extends ChannelSubsystem {
        protected SftpChannelSubsystem() {
            super("sftp");
        }

        @Override
        protected void doOpen() throws IOException {
            String systemName = this.getSubsystem();
            Session session = this.getSession();
            boolean wantReply = CoreModuleProperties.REQUEST_SUBSYSTEM_REPLY.getRequired(this);
            Buffer buffer = session.createBuffer((byte)98, "subsystem".length() + systemName.length() + 32);
            buffer.putInt(this.getRecipient());
            buffer.putString("subsystem");
            buffer.putBoolean(wantReply);
            buffer.putString(systemName);
            this.addPendingRequest("subsystem", wantReply);
            this.writePacket(buffer);
            this.asyncIn = this.createAsyncInput(session);
            this.setOut(this.createStdOutputStream(session));
            this.setErr(this.createErrOutputStream(session));
        }

        protected ChannelAsyncOutputStream createAsyncInput(final Session session) {
            return new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    try {
                        SftpChannelSubsystem.this.sendEof();
                    }
                    catch (IOException e) {
                        session.exceptionCaught(e);
                    }
                    return super.doCloseGracefully();
                }
            };
        }

        protected OutputStream createStdOutputStream(Session session) {
            return new OutputStream(){
                private final byte[] singleByte = new byte[1];

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b) throws IOException {
                    byte[] byArray = this.singleByte;
                    synchronized (this.singleByte) {
                        this.singleByte[0] = (byte)b;
                        this.write(this.singleByte);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    DefaultSftpClient.this.data(b, off, len);
                }
            };
        }

        protected OutputStream createErrOutputStream(Session session) {
            return new NullOutputStream();
        }
    }
}

