/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.client.extensions.helpers;

import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.NumberUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.BufferUtils;
import axion.org.apache.sshd.sftp.client.RawSftpClient;
import axion.org.apache.sshd.sftp.client.SftpClient;
import axion.org.apache.sshd.sftp.client.extensions.helpers.AbstractSftpClientExtension;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Collection;

public abstract class AbstractMD5HashExtension
extends AbstractSftpClientExtension {
    protected AbstractMD5HashExtension(String name, SftpClient client, RawSftpClient raw, Collection<String> extras) {
        super(name, client, raw, extras);
    }

    protected byte[] doGetHash(Object target, long offset, long length, byte[] quickHash) throws IOException {
        Buffer buffer = this.getCommandBuffer(target, 84 + NumberUtils.length(quickHash));
        String opcode = this.getName();
        this.putTarget(buffer, target);
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putBytes(quickHash == null ? GenericUtils.EMPTY_BYTE_ARRAY : quickHash);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doGetHash({})[{}] - offset={}, length={}, quick-hash={}", new Object[]{opcode, target instanceof CharSequence ? target : BufferUtils.toHex('\u0000', (byte[])target), offset, length, BufferUtils.toHex(':', quickHash)});
        }
        if ((buffer = this.checkExtendedReplyBuffer(this.receive(this.sendExtendedCommand(buffer)))) == null) {
            throw new StreamCorruptedException("Missing extended reply data");
        }
        String targetType = buffer.getString();
        if (String.CASE_INSENSITIVE_ORDER.compare(targetType, opcode) != 0) {
            throw new StreamCorruptedException("Mismatched reply target type: expected=" + opcode + ", actual=" + targetType);
        }
        byte[] hashValue = buffer.getBytes();
        if (debugEnabled) {
            this.log.debug("doGetHash({})[{}] - offset={}, length={}, quick-hash={} - result={}", new Object[]{opcode, target, offset, length, BufferUtils.toHex(':', quickHash), BufferUtils.toHex(':', hashValue)});
        }
        return hashValue;
    }
}

