/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.threads;

import axion.org.apache.sshd.common.future.CloseFuture;
import axion.org.apache.sshd.common.future.DefaultCloseFuture;
import axion.org.apache.sshd.common.future.SshFutureListener;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.threads.CloseableExecutorService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NoCloseExecutor
implements CloseableExecutorService {
    protected final ExecutorService executor;
    protected final CloseFuture closeFuture;

    public NoCloseExecutor(ExecutorService executor) {
        this.executor = executor;
        this.closeFuture = new DefaultCloseFuture(null, null);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        this.executor.execute(command);
    }

    @Override
    public void shutdown() {
        this.close(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.close(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.isClosed();
    }

    @Override
    public boolean isTerminated() {
        return this.isClosed();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return this.closeFuture.await(timeout, unit);
        }
        catch (IOException e) {
            throw (InterruptedException)new InterruptedException().initCause(e);
        }
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.closeFuture.setClosed();
        return this.closeFuture;
    }

    @Override
    public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeFuture.addListener(listener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeFuture.removeListener(listener);
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.isClosed();
    }
}

