/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.security;

import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.threads.ThreadUtils;
import java.security.Provider;
import java.util.Objects;

public interface SecurityProviderChoice
extends NamedResource {
    public static final SecurityProviderChoice EMPTY = new SecurityProviderChoice(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isNamedProviderUsed() {
            return false;
        }

        @Override
        public Provider getSecurityProvider() {
            return null;
        }

        public String toString() {
            return "EMPTY";
        }
    };

    default public boolean isNamedProviderUsed() {
        return true;
    }

    public Provider getSecurityProvider();

    public static SecurityProviderChoice toSecurityProviderChoice(final String name) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No name provided");
        return new SecurityProviderChoice(){
            private final String s;
            {
                this.s = SecurityProviderChoice.class.getSimpleName() + "[" + name + "]";
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isNamedProviderUsed() {
                return true;
            }

            @Override
            public Provider getSecurityProvider() {
                return null;
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static SecurityProviderChoice toSecurityProviderChoice(final Provider provider) {
        Objects.requireNonNull(provider, "No provider instance");
        return new SecurityProviderChoice(){
            private final String s;
            {
                this.s = SecurityProviderChoice.class.getSimpleName() + "[" + Provider.class.getSimpleName() + "][" + provider.getName() + "]";
            }

            @Override
            public String getName() {
                return provider.getName();
            }

            @Override
            public boolean isNamedProviderUsed() {
                return false;
            }

            @Override
            public Provider getSecurityProvider() {
                return provider;
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static Provider createProviderInstance(Class<?> anchor, String providerClassName) throws ReflectiveOperationException {
        return ThreadUtils.createDefaultInstance(anchor, Provider.class, providerClassName);
    }
}

