/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.config.keys.loader;

import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.config.keys.FilePasswordProvider;
import axion.org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.BufferUtils;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class AbstractKeyPairResourceParser
extends AbstractLoggingBean
implements KeyPairResourceParser {
    private final List<String> beginners;
    private final List<String> enders;
    private final List<List<String>> endingMarkers;

    protected AbstractKeyPairResourceParser(List<String> beginners, List<String> enders) {
        this.beginners = ValidateUtils.checkNotNullAndNotEmpty(beginners, "No begin markers", new Object[0]);
        this.enders = ValidateUtils.checkNotNullAndNotEmpty(enders, "No end markers", new Object[0]);
        ValidateUtils.checkTrue(beginners.size() == enders.size(), "Mismatched begin(%d)/end(%d) markers sizes", beginners.size(), enders.size());
        this.endingMarkers = new ArrayList<List<String>>(enders.size());
        enders.forEach(m -> this.endingMarkers.add(Collections.singletonList(m)));
    }

    public List<String> getBeginners() {
        return this.beginners;
    }

    public List<String> getEnders() {
        return this.enders;
    }

    public List<List<String>> getEndingMarkers() {
        return this.endingMarkers;
    }

    @Override
    public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        return KeyPairResourceParser.containsMarkerLine(lines, this.getBeginners());
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        List<KeyPair> keyPairs = Collections.emptyList();
        List<String> beginMarkers = this.getBeginners();
        List<List<String>> endMarkers = this.getEndingMarkers();
        AbstractMap.SimpleImmutableEntry<Integer, Integer> markerPos = KeyPairResourceParser.findMarkerLine(lines, beginMarkers);
        while (markerPos != null) {
            int startIndex = (Integer)markerPos.getKey();
            String startLine = lines.get(startIndex);
            int markerIndex = (Integer)markerPos.getValue();
            List<String> ender = endMarkers.get(markerIndex);
            if ((markerPos = KeyPairResourceParser.findMarkerLine(lines, ++startIndex, ender)) == null) {
                throw new StreamCorruptedException("Missing end marker (" + ender + ") after line #" + startIndex);
            }
            int endIndex = (Integer)markerPos.getKey();
            String endLine = lines.get(endIndex);
            Map.Entry<Map<String, String>, List<String>> result = this.separateDataLinesFromHeaders(session, resourceKey, startLine, endLine, lines.subList(startIndex, endIndex));
            Map<String, String> headers = result.getKey();
            List<String> dataLines = result.getValue();
            Collection<KeyPair> kps = this.extractKeyPairs(session, resourceKey, startLine, endLine, passwordProvider, dataLines == null ? Collections.emptyList() : dataLines, headers == null ? Collections.emptyMap() : headers);
            if (GenericUtils.isNotEmpty(kps)) {
                if (GenericUtils.isEmpty(keyPairs)) {
                    keyPairs = new LinkedList<KeyPair>(kps);
                } else {
                    keyPairs.addAll(kps);
                }
            }
            markerPos = KeyPairResourceParser.findMarkerLine(lines, endIndex + 1, beginMarkers);
        }
        return keyPairs;
    }

    protected Map.Entry<Map<String, String>, List<String>> separateDataLinesFromHeaders(SessionContext session, NamedResource resourceKey, String startLine, String endLine, List<String> dataLines) throws IOException, GeneralSecurityException {
        return new AbstractMap.SimpleImmutableEntry<Map<String, String>, List<String>>(Collections.emptyMap(), dataLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines, Map<String, String> headers) throws IOException, GeneralSecurityException {
        byte[] dataBytes = KeyPairResourceParser.extractDataBytes(lines);
        try {
            Collection<KeyPair> collection = this.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, dataBytes, headers);
            return collection;
        }
        finally {
            Arrays.fill(dataBytes, (byte)0);
        }
    }

    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, byte[] bytes, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex(this.getSimplifiedLogger(), Level.FINER, beginMarker, ':', 16, bytes);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Collection<KeyPair> collection = this.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, bais, headers);
            return collection;
        }
    }

    public abstract Collection<KeyPair> extractKeyPairs(SessionContext var1, NamedResource var2, String var3, String var4, FilePasswordProvider var5, InputStream var6, Map<String, String> var7) throws IOException, GeneralSecurityException;
}

