/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.compression;

import axion.org.apache.sshd.common.compression.BaseCompression;
import axion.org.apache.sshd.common.compression.Compression;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import java.io.IOException;
import java.io.StreamCorruptedException;

public class CompressionNone
extends BaseCompression {
    private Compression.Type type;
    private int level;

    public CompressionNone() {
        super("none");
    }

    @Override
    public void init(Compression.Type type, int level) {
        this.type = type;
        this.level = level;
    }

    @Override
    public boolean isCompressionExecuted() {
        return false;
    }

    @Override
    public void compress(Buffer buffer) throws IOException {
        if (!Compression.Type.Deflater.equals((Object)this.type)) {
            throw new StreamCorruptedException("Not set up for compression: " + (Object)((Object)this.type));
        }
    }

    @Override
    public void uncompress(Buffer from, Buffer to) throws IOException {
        if (!Compression.Type.Inflater.equals((Object)this.type)) {
            throw new StreamCorruptedException("Not set up for de-compression: " + (Object)((Object)this.type));
        }
        if (from != to) {
            throw new StreamCorruptedException("Separate de-compression buffers provided");
        }
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + (Object)((Object)this.type) + "/" + this.level + "]";
    }
}

