/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common;

import axion.org.apache.sshd.common.CommonModuleProperties;
import axion.org.apache.sshd.common.PropertyResolver;
import axion.org.apache.sshd.common.future.CloseFuture;
import axion.org.apache.sshd.common.future.SshFutureListener;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.time.Duration;

public interface Closeable
extends Channel {
    public CloseFuture close(boolean var1);

    public void addCloseFutureListener(SshFutureListener<CloseFuture> var1);

    public void removeCloseFutureListener(SshFutureListener<CloseFuture> var1);

    public boolean isClosed();

    public boolean isClosing();

    @Override
    default public boolean isOpen() {
        return !this.isClosed() && !this.isClosing();
    }

    @Override
    default public void close() throws IOException {
        Closeable.close(this);
    }

    public static Duration getMaxCloseWaitTime(PropertyResolver resolver) {
        return CommonModuleProperties.CLOSE_WAIT_TIMEOUT.getRequired(resolver);
    }

    public static void close(Closeable closeable) throws IOException {
        Duration maxWait;
        CloseFuture future;
        boolean successful;
        if (closeable == null) {
            return;
        }
        if (!(closeable.isClosed() || closeable.isClosing() || (successful = (future = closeable.close(true)).await(maxWait = closeable instanceof PropertyResolver ? Closeable.getMaxCloseWaitTime((PropertyResolver)((Object)closeable)) : CommonModuleProperties.CLOSE_WAIT_TIMEOUT.getRequiredDefault())))) {
            throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
        }
    }
}

