/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common;

import axion.org.apache.sshd.common.Factory;
import axion.org.apache.sshd.common.NamedFactory;
import axion.org.apache.sshd.common.channel.ChannelFactory;
import axion.org.apache.sshd.common.channel.RequestHandler;
import axion.org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import axion.org.apache.sshd.common.cipher.BuiltinCiphers;
import axion.org.apache.sshd.common.cipher.Cipher;
import axion.org.apache.sshd.common.compression.Compression;
import axion.org.apache.sshd.common.file.FileSystemFactory;
import axion.org.apache.sshd.common.file.nativefs.NativeFileSystemFactory;
import axion.org.apache.sshd.common.forward.DefaultForwarderFactory;
import axion.org.apache.sshd.common.forward.ForwarderFactory;
import axion.org.apache.sshd.common.helpers.AbstractFactoryManager;
import axion.org.apache.sshd.common.kex.BuiltinDHFactories;
import axion.org.apache.sshd.common.kex.KeyExchangeFactory;
import axion.org.apache.sshd.common.mac.BuiltinMacs;
import axion.org.apache.sshd.common.mac.Mac;
import axion.org.apache.sshd.common.random.Random;
import axion.org.apache.sshd.common.random.SingletonRandomFactory;
import axion.org.apache.sshd.common.session.ConnectionService;
import axion.org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import axion.org.apache.sshd.common.session.helpers.DefaultUnknownChannelReferenceHandler;
import axion.org.apache.sshd.common.signature.BuiltinSignatures;
import axion.org.apache.sshd.common.signature.Signature;
import axion.org.apache.sshd.common.util.ObjectBuilder;
import axion.org.apache.sshd.common.util.security.SecurityUtils;
import axion.org.apache.sshd.server.forward.ForwardingFilter;
import axion.org.apache.sshd.server.forward.RejectAllForwardingFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BaseBuilder<T extends AbstractFactoryManager, S extends BaseBuilder<T, S>>
implements ObjectBuilder<T> {
    public static final FileSystemFactory DEFAULT_FILE_SYSTEM_FACTORY = NativeFileSystemFactory.INSTANCE;
    public static final ForwardingFilter DEFAULT_FORWARDING_FILTER = RejectAllForwardingFilter.INSTANCE;
    public static final ForwarderFactory DEFAULT_FORWARDER_FACTORY = DefaultForwarderFactory.INSTANCE;
    public static final List<BuiltinCiphers> DEFAULT_CIPHERS_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr, BuiltinCiphers.aes128gcm, BuiltinCiphers.aes256gcm, BuiltinCiphers.aes128cbc, BuiltinCiphers.aes192cbc, BuiltinCiphers.aes256cbc));
    public static final List<BuiltinDHFactories> DEFAULT_KEX_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinDHFactories.ecdhp521, BuiltinDHFactories.ecdhp384, BuiltinDHFactories.ecdhp256, BuiltinDHFactories.dhgex256, BuiltinDHFactories.dhg18_512, BuiltinDHFactories.dhg17_512, BuiltinDHFactories.dhg16_512, BuiltinDHFactories.dhg15_512, BuiltinDHFactories.dhg14_256));
    public static final List<BuiltinMacs> DEFAULT_MAC_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinMacs.hmacsha256etm, BuiltinMacs.hmacsha512etm, BuiltinMacs.hmacsha1etm, BuiltinMacs.hmacsha256, BuiltinMacs.hmacsha512, BuiltinMacs.hmacsha1));
    public static final List<BuiltinSignatures> DEFAULT_SIGNATURE_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinSignatures.nistp256_cert, BuiltinSignatures.nistp384_cert, BuiltinSignatures.nistp521_cert, BuiltinSignatures.ed25519_cert, BuiltinSignatures.rsaSHA512_cert, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.nistp256, BuiltinSignatures.nistp384, BuiltinSignatures.nistp521, BuiltinSignatures.ed25519, BuiltinSignatures.sk_ecdsa_sha2_nistp256, BuiltinSignatures.sk_ssh_ed25519, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA256, BuiltinSignatures.rsa));
    public static final UnknownChannelReferenceHandler DEFAULT_UNKNOWN_CHANNEL_REFERENCE_HANDLER = DefaultUnknownChannelReferenceHandler.INSTANCE;
    protected Factory<T> factory;
    protected List<KeyExchangeFactory> keyExchangeFactories;
    protected List<NamedFactory<Cipher>> cipherFactories;
    protected List<NamedFactory<Compression>> compressionFactories;
    protected List<NamedFactory<Mac>> macFactories;
    protected List<NamedFactory<Signature>> signatureFactories;
    protected Factory<Random> randomFactory;
    protected List<ChannelFactory> channelFactories;
    protected FileSystemFactory fileSystemFactory;
    protected ForwarderFactory forwarderFactory;
    protected List<RequestHandler<ConnectionService>> globalRequestHandlers;
    protected ForwardingFilter forwardingFilter;
    protected ChannelStreamWriterResolver channelStreamPacketWriterResolver;
    protected UnknownChannelReferenceHandler unknownChannelReferenceHandler;

    protected S fillWithDefaultValues() {
        if (this.randomFactory == null) {
            this.randomFactory = new SingletonRandomFactory(SecurityUtils.getRandomFactory());
        }
        if (this.cipherFactories == null) {
            this.cipherFactories = BaseBuilder.setUpDefaultCiphers(false);
        }
        if (this.macFactories == null) {
            this.macFactories = BaseBuilder.setUpDefaultMacs(false);
        }
        if (this.fileSystemFactory == null) {
            this.fileSystemFactory = DEFAULT_FILE_SYSTEM_FACTORY;
        }
        if (this.forwardingFilter == null) {
            this.forwardingFilter = DEFAULT_FORWARDING_FILTER;
        }
        if (this.forwarderFactory == null) {
            this.forwarderFactory = DEFAULT_FORWARDER_FACTORY;
        }
        if (this.unknownChannelReferenceHandler == null) {
            this.unknownChannelReferenceHandler = DEFAULT_UNKNOWN_CHANNEL_REFERENCE_HANDLER;
        }
        return this.me();
    }

    public S keyExchangeFactories(List<KeyExchangeFactory> keyExchangeFactories) {
        this.keyExchangeFactories = keyExchangeFactories;
        return this.me();
    }

    public S signatureFactories(List<NamedFactory<Signature>> signatureFactories) {
        this.signatureFactories = signatureFactories;
        return this.me();
    }

    public S randomFactory(Factory<Random> randomFactory) {
        this.randomFactory = randomFactory;
        return this.me();
    }

    public S cipherFactories(List<NamedFactory<Cipher>> cipherFactories) {
        this.cipherFactories = cipherFactories;
        return this.me();
    }

    public S compressionFactories(List<NamedFactory<Compression>> compressionFactories) {
        this.compressionFactories = compressionFactories;
        return this.me();
    }

    public S macFactories(List<NamedFactory<Mac>> macFactories) {
        this.macFactories = macFactories;
        return this.me();
    }

    public S channelFactories(List<ChannelFactory> channelFactories) {
        this.channelFactories = channelFactories;
        return this.me();
    }

    public S fileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
        return this.me();
    }

    public S forwardingFilter(ForwardingFilter filter) {
        this.forwardingFilter = filter;
        return this.me();
    }

    public S forwarderFactory(ForwarderFactory forwarderFactory) {
        this.forwarderFactory = forwarderFactory;
        return this.me();
    }

    public S globalRequestHandlers(List<RequestHandler<ConnectionService>> globalRequestHandlers) {
        this.globalRequestHandlers = globalRequestHandlers;
        return this.me();
    }

    public S factory(Factory<T> factory) {
        this.factory = factory;
        return this.me();
    }

    public S channelStreamPacketWriterResolver(ChannelStreamWriterResolver resolver) {
        this.channelStreamPacketWriterResolver = resolver;
        return this.me();
    }

    public S unknownChannelReferenceHandler(UnknownChannelReferenceHandler handler) {
        this.unknownChannelReferenceHandler = handler;
        return this.me();
    }

    public T build(boolean isFillWithDefaultValues) {
        if (isFillWithDefaultValues) {
            this.fillWithDefaultValues();
        }
        AbstractFactoryManager ssh = (AbstractFactoryManager)this.factory.create();
        ssh.setKeyExchangeFactories(this.keyExchangeFactories);
        ssh.setSignatureFactories(this.signatureFactories);
        ssh.setRandomFactory(this.randomFactory);
        ssh.setCipherFactories(this.cipherFactories);
        ssh.setCompressionFactories(this.compressionFactories);
        ssh.setMacFactories(this.macFactories);
        ssh.setChannelFactories(this.channelFactories);
        ssh.setFileSystemFactory(this.fileSystemFactory);
        ssh.setForwardingFilter(this.forwardingFilter);
        ssh.setForwarderFactory(this.forwarderFactory);
        ssh.setGlobalRequestHandlers(this.globalRequestHandlers);
        ssh.setChannelStreamWriterResolver(this.channelStreamPacketWriterResolver);
        ssh.setUnknownChannelReferenceHandler(this.unknownChannelReferenceHandler);
        return (T)ssh;
    }

    @Override
    public T build() {
        return this.build(true);
    }

    protected S me() {
        return (S)this;
    }

    public static List<NamedFactory<Cipher>> setUpDefaultCiphers(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_CIPHERS_PREFERENCE);
    }

    public static List<NamedFactory<Mac>> setUpDefaultMacs(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_MAC_PREFERENCE);
    }
}

