/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.simple;

import axion.org.apache.sshd.client.config.hosts.HostConfigEntry;
import axion.org.apache.sshd.client.future.AuthFuture;
import axion.org.apache.sshd.client.future.ConnectFuture;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.client.session.ClientSessionCreator;
import axion.org.apache.sshd.client.simple.AbstractSimpleClient;
import axion.org.apache.sshd.client.simple.SimpleClient;
import axion.org.apache.sshd.common.AttributeRepository;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;

public abstract class AbstractSimpleClientSessionCreator
extends AbstractSimpleClient
implements ClientSessionCreator {
    private long connectTimeout;
    private long authenticateTimeout;

    protected AbstractSimpleClientSessionCreator() {
        this(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    protected AbstractSimpleClientSessionCreator(long connTimeout, long authTimeout) {
        this.setConnectTimeout(connTimeout);
        this.setAuthenticationTimeout(authTimeout);
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long timeout) {
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive connect timeout: %d", timeout);
        this.connectTimeout = timeout;
    }

    @Override
    public long getAuthenticationTimeout() {
        return this.authenticateTimeout;
    }

    @Override
    public void setAuthenticationTimeout(long timeout) {
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive authentication timeout: %d", timeout);
        this.authenticateTimeout = timeout;
    }

    @Override
    public ClientSession sessionLogin(SocketAddress target, String username, String password) throws IOException {
        return this.loginSession(this.connect(username, target), password);
    }

    @Override
    public ClientSession sessionLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.loginSession(this.connect(username, target), identity);
    }

    @Override
    public ClientSession sessionLogin(String uri, String password) throws IOException {
        return this.loginSession(this.connect(uri), password);
    }

    @Override
    public ClientSession sessionLogin(String uri, KeyPair identity) throws IOException {
        return this.loginSession(this.connect(uri), identity);
    }

    protected ClientSession loginSession(ConnectFuture future, String password) throws IOException {
        return this.authSession((ConnectFuture)future.verify(this.getConnectTimeout()), password);
    }

    protected ClientSession loginSession(ConnectFuture future, KeyPair identity) throws IOException {
        return this.authSession((ConnectFuture)future.verify(this.getConnectTimeout()), identity);
    }

    protected ClientSession authSession(ConnectFuture future, String password) throws IOException {
        ClientSession session = (ClientSession)future.getSession();
        session.addPasswordIdentity(password);
        return this.authSession(session);
    }

    protected ClientSession authSession(ConnectFuture future, KeyPair identity) throws IOException {
        ClientSession session = (ClientSession)future.getSession();
        session.addPublicKeyIdentity(identity);
        return this.authSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession authSession(ClientSession clientSession) throws IOException {
        ClientSession session = clientSession;
        IOException err = null;
        try {
            AuthFuture auth = session.auth();
            auth.verify(this.getAuthenticationTimeout());
            session = null;
        }
        catch (IOException e) {
            err = GenericUtils.accumulateException(err, e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    err = GenericUtils.accumulateException(err, e);
                }
            }
        }
        if (err != null) {
            throw err;
        }
        return clientSession;
    }

    public static SimpleClient wrap(final ClientSessionCreator creator, final Channel channel) {
        Objects.requireNonNull(creator, "No sessions creator");
        Objects.requireNonNull(channel, "No channel");
        return new AbstractSimpleClientSessionCreator(){

            @Override
            public ConnectFuture connect(String uri) throws IOException {
                return creator.connect(uri);
            }

            @Override
            public ConnectFuture connect(String username, String host, int port) throws IOException {
                return creator.connect(username, host, port);
            }

            @Override
            public ConnectFuture connect(String username, String host, int port, SocketAddress localAddress) throws IOException {
                return creator.connect(username, host, port, localAddress);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress address) throws IOException {
                return creator.connect(username, address);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress targetAddress, SocketAddress localAddress) throws IOException {
                return creator.connect(username, targetAddress, localAddress);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig) throws IOException {
                return creator.connect(hostConfig);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig, SocketAddress localAddress) throws IOException {
                return creator.connect(hostConfig, localAddress);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress) throws IOException {
                return creator.connect(hostConfig, context, localAddress);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress) throws IOException {
                return creator.connect(username, targetAddress, context, localAddress);
            }

            @Override
            public ConnectFuture connect(String username, String host, int port, AttributeRepository context, SocketAddress localAddress) throws IOException {
                return creator.connect(username, host, port, context, localAddress);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context) throws IOException {
                return creator.connect(hostConfig, context);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress address, AttributeRepository context) throws IOException {
                return creator.connect(username, address, context);
            }

            @Override
            public ConnectFuture connect(String username, String host, int port, AttributeRepository context) throws IOException {
                return creator.connect(username, host, port, context);
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }

            public String toString() {
                return SimpleClient.class.getSimpleName() + "[" + channel + "]";
            }
        };
    }
}

