/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.agent.common;

import axion.org.apache.sshd.agent.SshAgent;
import axion.org.apache.sshd.agent.SshAgentConstants;
import axion.org.apache.sshd.common.SshException;
import axion.org.apache.sshd.common.config.keys.KeyUtils;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.BufferUtils;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import axion.org.apache.sshd.common.util.threads.CloseableExecutorService;
import axion.org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractAgentProxy
extends AbstractLoggingBean
implements SshAgent,
ExecutorServiceCarrier {
    private CloseableExecutorService executor;
    private String channelType = "auth-agent-req@openssh.com";

    protected AbstractAgentProxy(CloseableExecutorService executorService) {
        this.executor = executorService;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public Iterable<? extends Map.Entry<PublicKey, String>> getIdentities() throws IOException {
        int cmd = 11;
        int okcmd = 12;
        if ("auth-agent-req".equals(this.channelType)) {
            cmd = 204;
            okcmd = 104;
        }
        Buffer buffer = this.createBuffer((byte)cmd, 1);
        int type = (buffer = this.request(this.prepare(buffer))).getUByte();
        if (type != okcmd) {
            throw new SshException("Bad agent identities answer: " + SshAgentConstants.getCommandMessageName(type));
        }
        int nbIdentities = buffer.getInt();
        if (nbIdentities < 0 || nbIdentities > 1024) {
            throw new SshException("Illogical identities count: " + nbIdentities);
        }
        ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>> keys = new ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>>(nbIdentities);
        boolean debugEnabled = this.log.isDebugEnabled();
        for (int i = 0; i < nbIdentities; ++i) {
            PublicKey key = buffer.getPublicKey();
            String comment = buffer.getString();
            if (debugEnabled) {
                this.log.debug("getIdentities() key type={}, comment={}, fingerprint={}", new Object[]{KeyUtils.getKeyType(key), comment, KeyUtils.getFingerPrint(key)});
            }
            keys.add(new AbstractMap.SimpleImmutableEntry<PublicKey, String>(key, comment));
        }
        return keys;
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session, PublicKey key, String algo, byte[] data) throws IOException {
        int cmd = 13;
        int okcmd = 14;
        if ("auth-agent-req".equals(this.channelType)) {
            cmd = 205;
            okcmd = 105;
        }
        Buffer buffer = this.createBuffer((byte)cmd);
        if ("auth-agent-req".equals(this.channelType)) {
            buffer.putString("sign");
        }
        buffer.putPublicKey(key);
        buffer.putBytes(data);
        buffer.putInt(0L);
        buffer = this.request(this.prepare(buffer));
        int responseType = buffer.getUByte();
        if (responseType != okcmd) {
            throw new SshException("Bad signing response type: " + SshAgentConstants.getCommandMessageName(responseType));
        }
        byte[] signature = buffer.getBytes();
        boolean debugEnabled = this.log.isDebugEnabled();
        String keyType = KeyUtils.getKeyType(key);
        if ("auth-agent-req".equals(this.channelType)) {
            if (debugEnabled) {
                this.log.debug("sign({}/{})[{}] : {}", new Object[]{algo, keyType, KeyUtils.getFingerPrint(key), BufferUtils.toHex(':', signature)});
            }
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(keyType, signature);
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(signature);
        String algorithm = buf.getString();
        signature = buf.getBytes();
        if (debugEnabled) {
            this.log.debug("sign({}/{})[{}] {}: {}", new Object[]{algo, keyType, KeyUtils.getFingerPrint(key), algorithm, BufferUtils.toHex(':', signature)});
        }
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(algorithm, signature);
    }

    @Override
    public void addIdentity(KeyPair kp, String comment) throws IOException {
        int available;
        int response;
        Buffer buffer = this.createBuffer((byte)17);
        buffer.putKeyPair(kp);
        buffer.putString(comment);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addIdentity({})[{}]: {}", new Object[]{KeyUtils.getKeyType(kp), comment, KeyUtils.getFingerPrint(kp.getPublic())});
        }
        int n = response = (available = (buffer = this.request(this.prepare(buffer))).available()) >= 1 ? buffer.getUByte() : -1;
        if (available != 1 || response != 6) {
            throw new SshException("Bad addIdentity response (" + SshAgentConstants.getCommandMessageName(response) + ") - available=" + available);
        }
    }

    @Override
    public void removeIdentity(PublicKey key) throws IOException {
        int available;
        int response;
        Buffer buffer = this.createBuffer((byte)18);
        buffer.putPublicKey(key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeIdentity({}) {}", (Object)KeyUtils.getKeyType(key), (Object)KeyUtils.getFingerPrint(key));
        }
        int n = response = (available = (buffer = this.request(this.prepare(buffer))).available()) >= 1 ? buffer.getUByte() : -1;
        if (available != 1 || response != 6) {
            throw new SshException("Bad removeIdentity response (" + SshAgentConstants.getCommandMessageName(response) + ") - available=" + available);
        }
    }

    @Override
    public void removeAllIdentities() throws IOException {
        int available;
        int response;
        Buffer buffer = this.createBuffer((byte)19, 1);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeAllIdentities");
        }
        int n = response = (available = (buffer = this.request(this.prepare(buffer))).available()) >= 1 ? buffer.getUByte() : -1;
        if (available != 1 || response != 6) {
            throw new SshException("Bad removeAllIdentities response (" + SshAgentConstants.getCommandMessageName(response) + ") - available=" + available);
        }
    }

    @Override
    public void close() throws IOException {
        CloseableExecutorService service = this.getExecutorService();
        if (service != null && !service.isShutdown()) {
            List<Runnable> runners = service.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("close() - shutdown runners count=" + GenericUtils.size(runners));
            }
        }
    }

    protected Buffer createBuffer(byte cmd) {
        return this.createBuffer(cmd, 0);
    }

    protected Buffer createBuffer(byte cmd, int extraLen) {
        ByteArrayBuffer buffer = new ByteArrayBuffer(extraLen <= 0 ? 256 : extraLen + 8, false);
        buffer.putInt(0L);
        ((Buffer)buffer).putByte(cmd);
        return buffer;
    }

    protected Buffer prepare(Buffer buffer) {
        int wpos = buffer.wpos();
        buffer.wpos(0);
        buffer.putInt(wpos - 4);
        buffer.wpos(wpos);
        return buffer;
    }

    protected abstract Buffer request(Buffer var1) throws IOException;
}

