/*
 * Decompiled with CFR 0.152.
 */
package axion.net.i2p.crypto.eddsa.math.bigint;

import axion.net.i2p.crypto.eddsa.math.Encoding;
import axion.net.i2p.crypto.eddsa.math.Field;
import axion.net.i2p.crypto.eddsa.math.FieldElement;
import axion.net.i2p.crypto.eddsa.math.bigint.BigIntegerFieldElement;
import java.io.Serializable;
import java.math.BigInteger;

public class BigIntegerLittleEndianEncoding
extends Encoding
implements Serializable {
    private static final long serialVersionUID = 3984579843759837L;
    private BigInteger mask;

    @Override
    public synchronized void setField(Field f) {
        super.setField(f);
        this.mask = BigInteger.ONE.shiftLeft(f.getb() - 1).subtract(BigInteger.ONE);
    }

    @Override
    public byte[] encode(FieldElement x) {
        return this.encode(((BigIntegerFieldElement)x).bi.and(this.mask));
    }

    public byte[] encode(BigInteger x) {
        int i;
        if (this.f == null) {
            throw new IllegalStateException("field not set");
        }
        byte[] in = x.toByteArray();
        byte[] out = new byte[this.f.getb() / 8];
        for (i = 0; i < in.length; ++i) {
            out[i] = in[in.length - 1 - i];
        }
        for (i = in.length; i < out.length; ++i) {
            out[i] = 0;
        }
        return out;
    }

    @Override
    public FieldElement decode(byte[] in) {
        if (this.f == null) {
            throw new IllegalStateException("field not set");
        }
        if (in.length != this.f.getb() / 8) {
            throw new IllegalArgumentException("Not a valid encoding");
        }
        return new BigIntegerFieldElement(this.f, this.toBigInteger(in).and(this.mask));
    }

    public BigInteger toBigInteger(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[in.length - 1 - i];
        }
        return new BigInteger(1, out);
    }

    @Override
    public boolean isNegative(FieldElement x) {
        return ((BigIntegerFieldElement)x).bi.testBit(0);
    }
}

