/*
 * Decompiled with CFR 0.152.
 */
package axion.com.googlecode.javaewah32;

import axion.com.googlecode.javaewah32.Buffer32;
import axion.com.googlecode.javaewah32.EWAHCompressedBitmap32;
import axion.com.googlecode.javaewah32.RunningLengthWord32;

public final class EWAHIterator32
implements Cloneable {
    private int pointer;
    final RunningLengthWord32 rlw;
    private final int size;

    public EWAHIterator32(Buffer32 buffer) {
        this.rlw = new RunningLengthWord32(buffer, 0);
        this.size = buffer.sizeInWords();
        this.pointer = 0;
    }

    private EWAHIterator32(int pointer, RunningLengthWord32 rlw, int size) {
        this.pointer = pointer;
        this.rlw = rlw;
        this.size = size;
    }

    public static EWAHIterator32 getEWAHIterator(EWAHCompressedBitmap32 bitmap) {
        return bitmap.getEWAHIterator();
    }

    public Buffer32 buffer() {
        return this.rlw.buffer;
    }

    public int literalWords() {
        return this.pointer - this.rlw.getNumberOfLiteralWords();
    }

    public boolean hasNext() {
        return this.pointer < this.size;
    }

    public RunningLengthWord32 next() {
        this.rlw.position = this.pointer;
        this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        return this.rlw;
    }

    public EWAHIterator32 clone() throws CloneNotSupportedException {
        return new EWAHIterator32(this.pointer, this.rlw.clone(), this.size);
    }
}

