/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import shadow.org.eclipse.jgit.errors.CorruptObjectException;
import shadow.org.eclipse.jgit.errors.LargeObjectException;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import shadow.org.eclipse.jgit.internal.storage.file.WindowCursor;
import shadow.org.eclipse.jgit.lib.AnyObjectId;
import shadow.org.eclipse.jgit.lib.Constants;
import shadow.org.eclipse.jgit.lib.InflaterCache;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectLoader;
import shadow.org.eclipse.jgit.lib.ObjectStream;
import shadow.org.eclipse.jgit.util.IO;
import shadow.org.eclipse.jgit.util.MutableInteger;
import shadow.org.eclipse.jgit.util.RawParseUtils;

public class UnpackedObject {
    private static final int BUFFER_SIZE = 8192;

    public static ObjectLoader parse(byte[] raw, AnyObjectId id) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (WindowCursor wc = new WindowCursor(null);){
            return UnpackedObject.open(new ByteArrayInputStream(raw), null, id, wc);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static ObjectLoader open(InputStream in, File path, AnyObjectId id, WindowCursor wc) throws IOException {
        try {
            in = UnpackedObject.buffer(in);
            in.mark(20);
            byte[] hdr = new byte[64];
            IO.readFully(in, hdr, 0, 2);
            if (UnpackedObject.isStandardFormat(hdr)) {
                in.reset();
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                int avail = UnpackedObject.readSome(zIn, hdr, 0, 64);
                if (avail < 5) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger p = new MutableInteger();
                int type = Constants.decodeTypeString(id, hdr, (byte)32, p);
                long size = RawParseUtils.parseLongBase10(hdr, p.value, p);
                if (size < 0L) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNegativeSize);
                }
                if (hdr[p.value++] != 0) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectGarbageAfterSize);
                }
                if (path == null && Integer.MAX_VALUE < size) {
                    LargeObjectException.ExceedsByteArrayLimit e = new LargeObjectException.ExceedsByteArrayLimit();
                    e.setObjectId(id);
                    throw e;
                }
                if (size < (long)wc.getStreamFileThreshold() || path == null) {
                    byte[] data = new byte[(int)size];
                    int n = avail - p.value;
                    if (n > 0) {
                        System.arraycopy(hdr, p.value, data, 0, n);
                    }
                    IO.readFully(zIn, data, n, data.length - n);
                    UnpackedObject.checkValidEndOfStream(in, inf, id, hdr);
                    return new ObjectLoader.SmallObject(type, data);
                }
                return new LargeObject(type, size, path, id, wc.db);
            }
            UnpackedObject.readSome(in, hdr, 2, 18);
            int c = hdr[0] & 0xFF;
            int type = c >> 4 & 7;
            long size = c & 0xF;
            int shift = 4;
            int p = 1;
            while ((c & 0x80) != 0) {
                c = hdr[p++] & 0xFF;
                size += (long)(c & 0x7F) << shift;
                shift += 7;
            }
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                }
            }
            if (path == null && Integer.MAX_VALUE < size) {
                LargeObjectException.ExceedsByteArrayLimit e = new LargeObjectException.ExceedsByteArrayLimit();
                e.setObjectId(id);
                throw e;
            }
            if (size < (long)wc.getStreamFileThreshold() || path == null) {
                in.reset();
                IO.skipFully(in, p);
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                byte[] data = new byte[(int)size];
                IO.readFully(zIn, data, 0, data.length);
                UnpackedObject.checkValidEndOfStream(in, inf, id, hdr);
                return new ObjectLoader.SmallObject(type, data);
            }
            return new LargeObject(type, size, path, id, wc.db);
        }
        catch (ZipException badStream) {
            CorruptObjectException coe = new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            coe.initCause(badStream);
            throw coe;
        }
    }

    static long getSize(InputStream in, AnyObjectId id, WindowCursor wc) throws IOException {
        try {
            in = UnpackedObject.buffer(in);
            in.mark(20);
            byte[] hdr = new byte[64];
            IO.readFully(in, hdr, 0, 2);
            if (UnpackedObject.isStandardFormat(hdr)) {
                in.reset();
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                int avail = UnpackedObject.readSome(zIn, hdr, 0, 64);
                if (avail < 5) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger p = new MutableInteger();
                Constants.decodeTypeString(id, hdr, (byte)32, p);
                long size = RawParseUtils.parseLongBase10(hdr, p.value, p);
                if (size < 0L) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNegativeSize);
                }
                return size;
            }
            UnpackedObject.readSome(in, hdr, 2, 18);
            int c = hdr[0] & 0xFF;
            long size = c & 0xF;
            int shift = 4;
            int p = 1;
            while ((c & 0x80) != 0) {
                c = hdr[p++] & 0xFF;
                size += (long)(c & 0x7F) << shift;
                shift += 7;
            }
            return size;
        }
        catch (ZipException badStream) {
            CorruptObjectException coe = new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            coe.initCause(badStream);
            throw coe;
        }
    }

    static void checkValidEndOfStream(InputStream in, Inflater inf, AnyObjectId id, byte[] buf) throws IOException, CorruptObjectException {
        while (true) {
            int r;
            try {
                r = inf.inflate(buf);
            }
            catch (DataFormatException e) {
                CorruptObjectException coe = new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
                coe.initCause(e);
                throw coe;
            }
            if (r != 0) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectIncorrectLength);
            }
            if (inf.finished()) {
                if (inf.getRemaining() == 0 && in.read() == -1) break;
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            if (!inf.needsInput()) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            r = in.read(buf);
            if (r <= 0) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            inf.setInput(buf, 0, r);
        }
    }

    static boolean isStandardFormat(byte[] hdr) {
        int fb = hdr[0] & 0xFF;
        return (fb & 0x8F) == 8 && (fb << 8 | hdr[1] & 0xFF) % 31 == 0;
    }

    static InputStream inflate(InputStream in, long size, final ObjectId id) {
        Inflater inf = InflaterCache.get();
        return new InflaterInputStream(in, inf, size){
            private long remaining;
            {
                super($anonymous0, $anonymous1);
                this.remaining = l;
            }

            @Override
            public int read(byte[] b, int off, int cnt) throws IOException {
                try {
                    int r = super.read(b, off, cnt);
                    if (r > 0) {
                        this.remaining -= (long)r;
                    }
                    return r;
                }
                catch (ZipException badStream) {
                    CorruptObjectException coe = new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
                    coe.initCause(badStream);
                    throw coe;
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    if (this.remaining <= 0L) {
                        UnpackedObject.checkValidEndOfStream(this.in, this.inf, id, new byte[64]);
                    }
                }
                finally {
                    InflaterCache.release(this.inf);
                    super.close();
                }
            }
        };
    }

    private static InflaterInputStream inflate(InputStream in, Inflater inf) {
        return new InflaterInputStream(in, inf, 8192);
    }

    static BufferedInputStream buffer(InputStream in) {
        return new BufferedInputStream(in, 8192);
    }

    static int readSome(InputStream in, byte[] hdr, int off, int cnt) throws IOException {
        int avail = 0;
        while (cnt > 0) {
            int n = in.read(hdr, off, cnt);
            if (n < 0) break;
            avail += n;
            off += n;
            cnt -= n;
        }
        return avail;
    }

    private static final class LargeObject
    extends ObjectLoader {
        private final int type;
        private final long size;
        private final File path;
        private final ObjectId id;
        private final FileObjectDatabase source;

        LargeObject(int type, long size, File path, AnyObjectId id, FileObjectDatabase db) {
            this.type = type;
            this.size = size;
            this.path = path;
            this.id = id.copy();
            this.source = db;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public boolean isLarge() {
            return true;
        }

        @Override
        public byte[] getCachedBytes() throws LargeObjectException {
            throw new LargeObjectException(this.id);
        }

        @Override
        public ObjectStream openStream() throws MissingObjectException, IOException {
            BufferedInputStream in;
            try {
                in = UnpackedObject.buffer(new FileInputStream(this.path));
            }
            catch (FileNotFoundException gone) {
                if (this.path.exists()) {
                    throw gone;
                }
                return this.source.open(this.id, this.type).openStream();
            }
            boolean ok = false;
            try {
                byte[] hdr = new byte[64];
                ((InputStream)in).mark(20);
                IO.readFully(in, hdr, 0, 2);
                if (UnpackedObject.isStandardFormat(hdr)) {
                    ((InputStream)in).reset();
                    in = UnpackedObject.buffer(UnpackedObject.inflate(in, this.size, this.id));
                    while (((InputStream)in).read() > 0) {
                    }
                } else {
                    UnpackedObject.readSome(in, hdr, 2, 18);
                    int c = hdr[0] & 0xFF;
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = hdr[p++] & 0xFF;
                    }
                    ((InputStream)in).reset();
                    IO.skipFully(in, p);
                    in = UnpackedObject.buffer(UnpackedObject.inflate(in, this.size, this.id));
                }
                ok = true;
                ObjectStream.Filter filter = new ObjectStream.Filter(this.type, this.size, in);
                return filter;
            }
            finally {
                if (!ok) {
                    ((InputStream)in).close();
                }
            }
        }
    }
}

