/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.crypto.lms;

import java.security.SecureRandom;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shadow.org.bouncycastle.crypto.KeyGenerationParameters;
import shadow.org.bouncycastle.pqc.crypto.lms.LMS;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (LMSKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom secureRandom = this.param.getRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, byArray, byArray2);
        return new AsymmetricCipherKeyPair(lMSPrivateKeyParameters.getPublicKey(), lMSPrivateKeyParameters);
    }
}

