/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.DERNull;
import shadow.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.jcajce.PKCS12Key;
import shadow.org.bouncycastle.jcajce.io.MacOutputStream;
import shadow.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.JcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import shadow.org.bouncycastle.operator.GenericKey;
import shadow.org.bouncycastle.operator.MacCalculator;
import shadow.org.bouncycastle.operator.OperatorCreationException;
import shadow.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import shadow.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;

public class JcePKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePKCS12MacCalculatorBuilderProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilderProvider setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                final PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                try {
                    final ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                    final Mac mac = JcePKCS12MacCalculatorBuilderProvider.this.helper.createMac(aSN1ObjectIdentifier.getId());
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                    final PKCS12Key pKCS12Key = new PKCS12Key(cArray);
                    mac.init(pKCS12Key, pBEParameterSpec);
                    return new MacCalculator(){

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return new AlgorithmIdentifier(aSN1ObjectIdentifier, pKCS12PBEParams);
                        }

                        public OutputStream getOutputStream() {
                            return new MacOutputStream(mac);
                        }

                        public byte[] getMac() {
                            return mac.doFinal();
                        }

                        public GenericKey getKey() {
                            return new GenericKey(this.getAlgorithmIdentifier(), pKCS12Key.getEncoded());
                        }
                    };
                }
                catch (Exception exception) {
                    throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
                }
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

