/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import shadow.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import shadow.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.MPInteger;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shadow.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shadow.org.bouncycastle.crypto.InvalidCipherTextException;
import shadow.org.bouncycastle.crypto.Wrapper;
import shadow.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import shadow.org.bouncycastle.crypto.agreement.X25519Agreement;
import shadow.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.ECDomainParameters;
import shadow.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.KeyParameter;
import shadow.org.bouncycastle.crypto.params.ParametersWithRandom;
import shadow.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.operator.PGPPad;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.RFC6637Utils;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import shadow.org.bouncycastle.util.BigIntegers;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
            if (pGPPublicKey.getAlgorithm() == 18) {
                PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                byte[] byArray2 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, new BcKeyFingerprintCalculator());
                if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                    X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
                    x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(this.random));
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = x25519KeyPairGenerator.generateKeyPair();
                    X25519Agreement x25519Agreement = new X25519Agreement();
                    x25519Agreement.init(asymmetricCipherKeyPair.getPrivate());
                    byte[] byArray3 = new byte[x25519Agreement.getAgreementSize()];
                    x25519Agreement.calculateAgreement(asymmetricKeyParameter, byArray3, 0);
                    byte[] byArray4 = new byte[33];
                    byArray4[0] = 64;
                    ((X25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).encode(byArray4, 1);
                    return this.encryptSessionInfo(eCDHPublicBCPGKey, byArray, byArray3, byArray2, byArray4);
                }
                ECDomainParameters eCDomainParameters = ((ECPublicKeyParameters)asymmetricKeyParameter).getParameters();
                ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
                eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, this.random));
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
                ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
                eCDHBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement(asymmetricKeyParameter);
                byte[] byArray5 = BigIntegers.asUnsignedByteArray(eCDHBasicAgreement.getFieldSize(), bigInteger);
                byte[] byArray6 = ((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getQ().getEncoded(false);
                return this.encryptSessionInfo(eCDHPublicBCPGKey, byArray, byArray5, byArray2, byArray6);
            }
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encrypting session info: " + iOException.getMessage(), iOException);
        }
    }

    private byte[] encryptSessionInfo(ECDHPublicBCPGKey eCDHPublicBCPGKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws IOException, PGPException {
        RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        KeyParameter keyParameter = new KeyParameter(rFC6637KDFCalculator.createKey(byArray2, byArray3));
        byte[] byArray5 = PGPPad.padSessionData(byArray);
        Wrapper wrapper = BcImplProvider.createWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        wrapper.init(true, new ParametersWithRandom(keyParameter, this.random));
        byte[] byArray6 = wrapper.wrap(byArray5, 0, byArray5.length);
        byte[] byArray7 = new MPInteger(new BigInteger(1, byArray4)).getEncoded();
        byte[] byArray8 = new byte[byArray7.length + 1 + byArray6.length];
        System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
        byArray8[byArray7.length] = (byte)byArray6.length;
        System.arraycopy(byArray6, 0, byArray8, byArray7.length + 1, byArray6.length);
        return byArray8;
    }
}

