/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.DEROctetString;
import shadow.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import shadow.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import shadow.org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import shadow.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shadow.org.bouncycastle.asn1.x9.X9ECParameters;
import shadow.org.bouncycastle.asn1.x9.X9ECPoint;
import shadow.org.bouncycastle.bcpg.BCPGKey;
import shadow.org.bouncycastle.bcpg.DSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.DSASecretBCPGKey;
import shadow.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ECPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ECSecretBCPGKey;
import shadow.org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.EdSecretBCPGKey;
import shadow.org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.RSASecretBCPGKey;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.DSAParameters;
import shadow.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.ECDomainParameters;
import shadow.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import shadow.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.ElGamalParameters;
import shadow.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.RSAKeyParameters;
import shadow.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import shadow.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import shadow.org.bouncycastle.crypto.util.PrivateKeyFactory;
import shadow.org.bouncycastle.crypto.util.PublicKeyFactory;
import shadow.org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPKdfParameters;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.BigIntegers;

public class BcPGPKeyConverter {
    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BCPGKey bCPGKey = this.getPrivateBCPGKey(pGPPublicKey, asymmetricKeyParameter);
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), bCPGKey);
    }

    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        BCPGKey bCPGKey = this.getPublicBCPGKey(n, pGPAlgorithmParameters, asymmetricKeyParameter, date);
        return new PGPPublicKey(new PublicKeyPacket(n, date, bCPGKey), new BcKeyFingerprintCalculator());
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    return new DSAPrivateKeyParameters(dSASecretBCPGKey.getX(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    if (CryptlibObjectIdentifiers.curvey25519.equals(eCDHPublicBCPGKey.getCurveOID())) {
                        return this.implGetPrivateKeyPKCS8(new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(Arrays.reverse(BigIntegers.asUnsignedByteArray(eCSecretBCPGKey.getX())))));
                    }
                    return this.implGetPrivateKeyEC(eCDHPublicBCPGKey, eCSecretBCPGKey);
                }
                case 19: {
                    return this.implGetPrivateKeyEC((ECDSAPublicBCPGKey)publicKeyPacket.getKey(), (ECSecretBCPGKey)bCPGKey);
                }
                case 22: {
                    EdSecretBCPGKey edSecretBCPGKey = (EdSecretBCPGKey)bCPGKey;
                    return this.implGetPrivateKeyPKCS8(new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), new DEROctetString(BigIntegers.asUnsignedByteArray(edSecretBCPGKey.getX()))));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    return new ElGamalPrivateKeyParameters(elGamalSecretBCPGKey.getX(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    return new RSAPrivateCrtKeyParameters(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new DSAPublicKeyParameters(dSAPublicBCPGKey.getY(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] byArray = BigIntegers.asUnsignedByteArray(eCDHPublicBCPGKey.getEncodedPoint());
                        if (byArray.length < 1 || 64 != byArray[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        return this.implGetPublicKeyX509(new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), Arrays.copyOfRange(byArray, 1, byArray.length)));
                    }
                    return this.implGetPublicKeyEC(eCDHPublicBCPGKey);
                }
                case 19: {
                    return this.implGetPublicKeyEC((ECDSAPublicBCPGKey)publicKeyPacket.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    byte[] byArray = BigIntegers.asUnsignedByteArray(edDSAPublicBCPGKey.getEncodedPoint());
                    if (byArray.length < 1 || 64 != byArray[0]) {
                        throw new IllegalArgumentException("Invalid Ed25519 public key");
                    }
                    return this.implGetPublicKeyX509(new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), Arrays.copyOfRange(byArray, 1, byArray.length)));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    return new ElGamalPublicKeyParameters(elGamalPublicBCPGKey.getY(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new RSAKeyParameters(false, rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        switch (pGPPublicKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                return new DSASecretBCPGKey(dSAPrivateKeyParameters.getX());
            }
            case 18: {
                if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
                    ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                    return new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
                }
                X25519PrivateKeyParameters x25519PrivateKeyParameters = (X25519PrivateKeyParameters)asymmetricKeyParameter;
                return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverse(x25519PrivateKeyParameters.getEncoded())));
            }
            case 19: {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                return new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
            }
            case 22: {
                Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = (Ed25519PrivateKeyParameters)asymmetricKeyParameter;
                return new EdSecretBCPGKey(new BigInteger(1, ed25519PrivateKeyParameters.getEncoded()));
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                return new ElGamalSecretBCPGKey(elGamalPrivateKeyParameters.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
                return new RSASecretBCPGKey(rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            return new RSAPublicBCPGKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            return new DSAPublicBCPGKey(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG(), dSAPublicKeyParameters.getY());
        }
        if (asymmetricKeyParameter instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricKeyParameter;
            ElGamalParameters elGamalParameters = elGamalPublicKeyParameters.getParameters();
            return new ElGamalPublicBCPGKey(elGamalParameters.getP(), elGamalParameters.getG(), elGamalPublicKeyParameters.getY());
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            try {
                subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter);
            }
            catch (IOException iOException) {
                throw new PGPException("Unable to encode key: " + iOException.getMessage(), iOException);
            }
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
            DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), dEROctetString);
            if (n == 18) {
                PGPKdfParameters pGPKdfParameters = (PGPKdfParameters)pGPAlgorithmParameters;
                if (pGPKdfParameters == null) {
                    pGPKdfParameters = new PGPKdfParameters(8, 7);
                }
                return new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            }
            if (n == 19) {
                return new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
            byte[] byArray = new byte[33];
            byArray[0] = 64;
            ((Ed25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, byArray));
        }
        if (asymmetricKeyParameter instanceof X25519PublicKeyParameters) {
            byte[] byArray = new byte[33];
            byArray[0] = 64;
            ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
            PGPKdfParameters pGPKdfParameters = (PGPKdfParameters)pGPAlgorithmParameters;
            if (pGPKdfParameters == null) {
                pGPKdfParameters = new PGPKdfParameters(8, 7);
            }
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, byArray), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
        }
        throw new PGPException("unknown key class");
    }

    private ECNamedDomainParameters implGetParametersEC(ECPublicBCPGKey eCPublicBCPGKey) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        X9ECParameters x9ECParameters = BcUtil.getX9Parameters(aSN1ObjectIdentifier);
        return new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    private AsymmetricKeyParameter implGetPrivateKeyEC(ECPublicBCPGKey eCPublicBCPGKey, ECSecretBCPGKey eCSecretBCPGKey) throws IOException, PGPException {
        ECNamedDomainParameters eCNamedDomainParameters = this.implGetParametersEC(eCPublicBCPGKey);
        return new ECPrivateKeyParameters(eCSecretBCPGKey.getX(), (ECDomainParameters)eCNamedDomainParameters);
    }

    private AsymmetricKeyParameter implGetPrivateKeyPKCS8(PrivateKeyInfo privateKeyInfo) throws IOException {
        return PrivateKeyFactory.createKey(privateKeyInfo);
    }

    private AsymmetricKeyParameter implGetPublicKeyEC(ECPublicBCPGKey eCPublicBCPGKey) throws IOException, PGPException {
        ECNamedDomainParameters eCNamedDomainParameters = this.implGetParametersEC(eCPublicBCPGKey);
        ECPoint eCPoint = BcUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), eCNamedDomainParameters.getCurve());
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)eCNamedDomainParameters);
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

