/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.InputStreamPacket;
import shadow.org.bouncycastle.bcpg.Packet;
import shadow.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import shadow.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import shadow.org.bouncycastle.openpgp.PGPEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPPBEEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import shadow.org.bouncycastle.openpgp.Util;
import shadow.org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPEncryptedDataList
implements Iterable<PGPEncryptedData> {
    List<PGPEncryptedData> methods = new ArrayList<PGPEncryptedData>();
    InputStreamPacket data;

    public PGPEncryptedDataList(byte[] byArray) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(byArray), 1, 3));
    }

    public PGPEncryptedDataList(InputStream inputStream) throws IOException {
        this(Util.createBCPGInputStream(inputStream, 1, 3));
    }

    public PGPEncryptedDataList(BCPGInputStream bCPGInputStream) throws IOException {
        ArrayList<Packet> arrayList = new ArrayList<Packet>();
        while (bCPGInputStream.nextPacketTag() == 1 || bCPGInputStream.nextPacketTag() == 3) {
            arrayList.add(bCPGInputStream.readPacket());
        }
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof InputStreamPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (InputStreamPacket)packet;
        for (int i = 0; i != arrayList.size(); ++i) {
            if (arrayList.get(i) instanceof SymmetricKeyEncSessionPacket) {
                this.methods.add(new PGPPBEEncryptedData((SymmetricKeyEncSessionPacket)arrayList.get(i), this.data));
                continue;
            }
            this.methods.add(new PGPPublicKeyEncryptedData((PublicKeyEncSessionPacket)arrayList.get(i), this.data));
        }
    }

    public PGPEncryptedData get(int n) {
        return this.methods.get(n);
    }

    public int size() {
        return this.methods.size();
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public Iterator<PGPEncryptedData> getEncryptedDataObjects() {
        return this.methods.iterator();
    }

    @Override
    public Iterator<PGPEncryptedData> iterator() {
        return this.getEncryptedDataObjects();
    }
}

