/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shadow.org.bouncycastle.crypto.KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

