/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.BCPGObject;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;

public class S2K
extends BCPGObject {
    private static final int EXPBIAS = 6;
    public static final int SIMPLE = 0;
    public static final int SALTED = 1;
    public static final int SALTED_AND_ITERATED = 3;
    public static final int GNU_DUMMY_S2K = 101;
    public static final int GNU_PROTECTION_MODE_NO_PRIVATE_KEY = 1;
    public static final int GNU_PROTECTION_MODE_DIVERT_TO_CARD = 2;
    int type;
    int algorithm;
    byte[] iv;
    int itCount = -1;
    int protectionMode = -1;

    S2K(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.type = dataInputStream.read();
        this.algorithm = dataInputStream.read();
        if (this.type != 101) {
            if (this.type != 0) {
                this.iv = new byte[8];
                dataInputStream.readFully(this.iv, 0, this.iv.length);
                if (this.type == 3) {
                    this.itCount = dataInputStream.read();
                }
            }
        } else {
            dataInputStream.read();
            dataInputStream.read();
            dataInputStream.read();
            this.protectionMode = dataInputStream.read();
        }
    }

    public S2K(int n) {
        this.type = 0;
        this.algorithm = n;
    }

    public S2K(int n, byte[] byArray) {
        this.type = 1;
        this.algorithm = n;
        this.iv = byArray;
    }

    public S2K(int n, byte[] byArray, int n2) {
        this.type = 3;
        this.algorithm = n;
        this.iv = byArray;
        this.itCount = n2;
    }

    public int getType() {
        return this.type;
    }

    public int getHashAlgorithm() {
        return this.algorithm;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public long getIterationCount() {
        return 16 + (this.itCount & 0xF) << (this.itCount >> 4) + 6;
    }

    public int getProtectionMode() {
        return this.protectionMode;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.write(this.type);
        bCPGOutputStream.write(this.algorithm);
        if (this.type != 101) {
            if (this.type != 0) {
                bCPGOutputStream.write(this.iv);
            }
            if (this.type == 3) {
                bCPGOutputStream.write(this.itCount);
            }
        } else {
            bCPGOutputStream.write(71);
            bCPGOutputStream.write(78);
            bCPGOutputStream.write(85);
            bCPGOutputStream.write(this.protectionMode);
        }
    }
}

