/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.googlecode.javaewah.datastructure;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import shadow.com.googlecode.javaewah.IntIterator;
import shadow.com.googlecode.javaewah.datastructure.WordArray;

public class BitSet
implements Cloneable,
Iterable<Integer>,
Externalizable,
WordArray {
    long[] data;
    static final long serialVersionUID = 7997698588986878754L;

    public BitSet(int sizeInBits) {
        this.data = new long[(sizeInBits + 63) / 64];
    }

    public BitSet() {
        this.data = new long[0];
    }

    public void and(WordArray bs) {
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            int n = k;
            this.data[n] = this.data[n] & bs.getWord(k);
        }
    }

    public int andcardinality(WordArray bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            sum += Long.bitCount(this.getWord(k) & bs.getWord(k));
        }
        return sum;
    }

    public void andNot(WordArray bs) {
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            int n = k;
            this.data[n] = this.data[n] & (bs.getWord(k) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int andNotcardinality(WordArray bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            sum += Long.bitCount(this.getWord(k) & (bs.getWord(k) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return sum;
    }

    public int cardinality() {
        int sum = 0;
        for (long l : this.data) {
            sum += Long.bitCount(l);
        }
        return sum;
    }

    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    public void clear(int index) {
        this.unset(index);
    }

    public void clear(int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            this.data[n] = this.data[n] & (-1L << start & -1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n = firstword;
        this.data[n] = this.data[n] & (-1L << start ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword + 1; i < endword; ++i) {
            this.data[i] = 0L;
        }
        int n2 = endword;
        this.data[n2] = this.data[n2] & (-1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public BitSet clone() {
        try {
            BitSet b = (BitSet)super.clone();
            b.data = Arrays.copyOf(this.data, this.getNumberOfWords());
            return b;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof WordArray) {
            WordArray bs = (WordArray)o;
            for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
                if (this.getWord(k) == bs.getWord(k)) continue;
                return false;
            }
            WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
            for (int k = Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); k < Math.max(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
                if (longer.getWord(k) == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean empty() {
        for (long l : this.data) {
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] ^ 1L << i % 64;
    }

    public void flip(int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        int n = firstword;
        this.data[n] = this.data[n] ^ (-1L << start ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword; i < endword; ++i) {
            this.data[i] = this.data[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endword;
        this.data[n2] = this.data[n2] ^ -1L >>> -end;
    }

    public boolean get(int i) {
        return (this.data[i / 64] & 1L << i % 64) != 0L;
    }

    public int hashCode() {
        int b = 31;
        long hash = 0L;
        for (int k = 0; k < this.data.length; ++k) {
            long aData = this.getWord(k);
            hash = hash * (long)b + aData;
        }
        return (int)hash;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = BitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                this.j = this.i;
                this.i = BitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }

            @Override
            public void remove() {
                BitSet.this.unset(this.j);
            }
        };
    }

    public boolean intersects(WordArray bs) {
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            if ((this.getWord(k) & bs.getWord(k)) == 0L) continue;
            return true;
        }
        return false;
    }

    public int nextSetBit(int i) {
        int x = i / 64;
        if (x >= this.getNumberOfWords()) {
            return -1;
        }
        long w = this.data[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.getNumberOfWords()) {
            if (this.data[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x]);
            }
            ++x;
        }
        return -1;
    }

    public int nextUnsetBit(int i) {
        int x = i / 64;
        if (x >= this.getNumberOfWords()) {
            return -1;
        }
        long w = this.data[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.getNumberOfWords()) {
            if (this.data[x] != -1L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++x;
        }
        return -1;
    }

    public void or(WordArray bs) {
        if (this.getNumberOfWords() < bs.getNumberOfWords()) {
            this.resize(bs.getNumberOfWords() * 64);
        }
        for (int k = 0; k < this.getNumberOfWords(); ++k) {
            int n = k;
            this.data[n] = this.data[n] | bs.getWord(k);
        }
    }

    public int orcardinality(WordArray bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            sum += Long.bitCount(this.getWord(k) | bs.getWord(k));
        }
        WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
        for (int k = Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); k < Math.max(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            sum += Long.bitCount(longer.getWord(k));
        }
        return sum;
    }

    public void removeWord(int i) {
        long[] newdata = new long[this.data.length - 1];
        if (i == 0) {
            System.arraycopy(this.data, 1, newdata, 0, i - 1);
        }
        System.arraycopy(this.data, 0, newdata, 0, i - 1);
        System.arraycopy(this.data, i, newdata, i - 1, this.data.length - i);
        this.data = newdata;
    }

    public void resize(int sizeInBits) {
        this.data = Arrays.copyOf(this.data, (sizeInBits + 63) / 64);
    }

    public void set(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] | 1L << i % 64;
    }

    public void set(int i, boolean b) {
        if (b) {
            this.set(i);
        } else {
            this.unset(i);
        }
    }

    public void set(int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            this.data[n] = this.data[n] | -1L << start & -1L >>> -end;
            return;
        }
        int n = firstword;
        this.data[n] = this.data[n] | -1L << start;
        for (int i = firstword + 1; i < endword; ++i) {
            this.data[i] = -1L;
        }
        int n2 = endword;
        this.data[n2] = this.data[n2] | -1L >>> -end;
    }

    public void set(int start, int end, boolean v) {
        if (v) {
            this.set(start, end);
        } else {
            this.clear(start, end);
        }
    }

    public int size() {
        return this.getNumberOfWords() * 64;
    }

    public void trim() {
        for (int k = this.getNumberOfWords() - 1; k >= 0; --k) {
            if (this.getWord(k) == 0L) continue;
            if (k + 1 < this.getNumberOfWords()) {
                this.data = Arrays.copyOf(this.data, k + 1);
            }
            return;
        }
        this.data = new long[0];
    }

    public void unset(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] & (1L << i % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IntIterator unsetIntIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextUnsetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = BitSet.this.nextUnsetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeLong(this.getNumberOfWords());
        for (long w : this.data) {
            out.writeLong(w);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        int length = (int)in.readLong();
        this.data = new long[length];
        for (int k = 0; k < length; ++k) {
            this.data[k] = in.readLong();
        }
    }

    public void xor(WordArray bs) {
        if (this.getNumberOfWords() < bs.getNumberOfWords()) {
            this.resize(bs.getNumberOfWords() * 64);
        }
        for (int k = 0; k < this.getNumberOfWords(); ++k) {
            int n = k;
            this.data[n] = this.data[n] ^ bs.getWord(k);
        }
    }

    public int xorcardinality(WordArray bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k) {
            sum += Long.bitCount(this.getWord(k) ^ bs.getWord(k));
        }
        WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
        int start = Math.min(this.getNumberOfWords(), bs.getNumberOfWords());
        int end = Math.max(this.getNumberOfWords(), bs.getNumberOfWords());
        for (int k = start; k < end; ++k) {
            sum += Long.bitCount(longer.getWord(k));
        }
        return sum;
    }

    @Override
    public int getNumberOfWords() {
        return this.data.length;
    }

    @Override
    public long getWord(int index) {
        return this.data[index];
    }

    public static BitSet bitmapOf(int ... setBits) {
        int maxv = 0;
        for (int k : setBits) {
            if (maxv >= k) continue;
            maxv = k;
        }
        BitSet a = new BitSet(maxv + 1);
        for (int k : setBits) {
            a.set(k);
        }
        return a;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }
}

