/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.SavePropertyBindingImpl;
import org.zkoss.bind.impl.ValidationContextImpl;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

class ValidationHelper {
    private final Binder _binder;
    private final InfoProvider _infoProvider;
    private Map<Binding, Property> _mainPropertyCache;

    public ValidationHelper(Binder binder, InfoProvider infoProvider) {
        this._binder = binder;
        this._infoProvider = infoProvider;
        this._mainPropertyCache = new HashMap<Binding, Property>(2);
    }

    public void collectSaveBefore(Component comp, String command, Event evt, Set<Property> validates) {
        this.collectSavePropertyBefore(comp, command, evt, validates);
        this.collectSaveFormBefore(comp, command, evt, validates);
    }

    private void collectSavePropertyBefore(Component comp, String command, Event evt, Set<Property> validates) {
        List<SavePropertyBinding> bindings = this._infoProvider.getSaveBeforeBindings().get(command);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.collectSavePropertyBinding(comp, binding, command, evt, validates);
            }
        }
    }

    private void collectSaveFormBefore(Component comp, String command, Event evt, Set<Property> validates) {
        List<SaveFormBinding> bindings = this._infoProvider.getSaveFormBeforeBindings().get(command);
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                this.collectSaveFormBinding(comp, binding, command, evt, validates);
            }
        }
    }

    public void collectSaveAfter(Component comp, String command, Event evt, Set<Property> validates) {
        this.collectSavePropertyAfter(comp, command, evt, validates);
        this.collectSaveFormAfter(comp, command, evt, validates);
    }

    private void collectSavePropertyAfter(Component comp, String command, Event evt, Set<Property> validates) {
        List<SavePropertyBinding> bindings = this._infoProvider.getSaveAfterBindings().get(command);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.collectSavePropertyBinding(comp, binding, command, evt, validates);
            }
        }
    }

    private void collectSaveFormAfter(Component comp, String command, Event evt, Set<Property> validates) {
        List<SaveFormBinding> bindings = this._infoProvider.getSaveFormAfterBindings().get(command);
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                this.collectSaveFormBinding(comp, binding, command, evt, validates);
            }
        }
    }

    public boolean validateSaveBefore(Component comp, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        boolean r = valid;
        r &= this.validateSavePropertyBefore(comp, command, validates, r, notifys);
        r &= this.validateSaveFormBefore(comp, command, validates, r, notifys);
        return r;
    }

    private boolean validateSavePropertyBefore(Component comp, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._infoProvider.getSaveBeforeBindings().get(command);
        boolean r = valid;
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                r &= this.validateSavePropertyBinding(comp, binding, command, validates, r, notifys);
            }
        }
        return r;
    }

    private boolean validateSaveFormBefore(Component comp, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        List<SaveFormBinding> bindings = this._infoProvider.getSaveFormBeforeBindings().get(command);
        boolean r = valid;
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                r &= this.validateSaveFormBinding(comp, binding, command, validates, r, notifys);
            }
        }
        return r;
    }

    public boolean validateSaveAfter(Component comp, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        boolean r = valid;
        r &= this.validateSavePropertyAfter(comp, command, validates, r, notifys);
        r &= this.validateSaveFormAfter(comp, command, validates, r, notifys);
        return r;
    }

    private boolean validateSavePropertyAfter(Component comp, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._infoProvider.getSaveAfterBindings().get(command);
        boolean r = true;
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                r &= this.validateSavePropertyBinding(comp, binding, command, validates, valid, notifys);
            }
        }
        return r;
    }

    private boolean validateSaveFormAfter(Component comp, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        List<SaveFormBinding> bindings = this._infoProvider.getSaveFormAfterBindings().get(command);
        boolean r = valid;
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                r &= this.validateSaveFormBinding(comp, binding, command, validates, r, notifys);
            }
        }
        return r;
    }

    private void collectSavePropertyBinding(Component comp, SavePropertyBinding binding, String command, Event evt, Set<Property> validates, boolean checkFormFieldFromCollection) {
        Property pc;
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, command, binding.getComponent(), evt);
        BindContextUtil.setConverterArgs(this._binder, binding.getComponent(), ctx, binding);
        HashSet<Property> cp = new HashSet<Property>();
        Property p = binding.getValidate(ctx);
        this._mainPropertyCache.put(binding, p);
        cp.add(p);
        if (checkFormFieldFromCollection && (pc = ((SavePropertyBindingImpl)binding).getBasePropertyIfFromCollection()) != null) {
            cp.add(pc);
        }
        validates.addAll(cp);
    }

    private void collectSavePropertyBinding(Component comp, SavePropertyBinding binding, String command, Event evt, Set<Property> validates) {
        this.collectSavePropertyBinding(comp, binding, command, evt, validates, false);
    }

    private void collectSaveFormBinding(Component comp, SaveFormBinding binding, String command, Event evt, Set<Property> validates) {
        String formId = binding.getFormId();
        Component formComp = binding.getComponent();
        Binder binder = binding.getBinder();
        Form form = ((BinderCtrl)((Object)binding.getBinder())).getForm(formComp, formId);
        if (form instanceof FormProxyObject) {
            Set<Pair<String, SavePropertyBinding>> cachedSavePropertyBindings = ((FormProxyObject)((Object)form)).collectCachedSavePropertyBinding();
            for (Pair pair : cachedSavePropertyBindings) {
                SavePropertyBinding spbinding = (SavePropertyBinding)pair.getY();
                String fieldName = (String)pair.getX();
                Component cachedComp = spbinding.getComponent();
                if (cachedComp.getDesktop() == null) continue;
                ((BinderCtrl)((Object)binder)).addFormAssociatedSaveBinding(spbinding.getComponent(), formId, spbinding, fieldName);
                ((BinderCtrl)((Object)binder)).addSaveFormFieldName(form, fieldName);
            }
        }
        Set<SaveBinding> savebindings = ((BinderCtrl)((Object)binder)).getFormAssociatedSaveBindings(formComp);
        for (SaveBinding saveBinding : savebindings) {
            if (!(saveBinding instanceof SavePropertyBinding)) continue;
            this.collectSavePropertyBinding(comp, (SavePropertyBinding)saveBinding, command, evt, validates, true);
        }
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, command, binding.getComponent(), evt);
        HashSet<Property> hashSet = new HashSet<Property>();
        Property p = binding.getValidate(ctx);
        this._mainPropertyCache.put(binding, p);
        hashSet.add(p);
        hashSet.addAll(binding.getValidates(ctx));
        validates.addAll(hashSet);
    }

    private boolean validateSavePropertyBinding(Component comp, SavePropertyBinding binding, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        if (!binding.hasValidator()) {
            return true;
        }
        if (((BinderImpl)binding.getBinder()).hasValidator(binding.getComponent(), binding.getFieldName())) {
            this.clearValidationMessage(binding.getBinder(), binding.getComponent(), binding.getFieldName());
        }
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, command, binding.getComponent(), null);
        BindContextUtil.setValidatorArgs(binding.getBinder(), binding.getComponent(), ctx, binding);
        Property p = this._mainPropertyCache.get(binding);
        ValidationContextImpl vContext = new ValidationContextImpl(command, p, validates, ctx, valid);
        binding.validate(vContext);
        Set<Property> xnotifys = ValidationHelper.getNotifys(ctx);
        if (xnotifys != null) {
            notifys.addAll(xnotifys);
        }
        return vContext.isValid();
    }

    private void clearValidationMessage(Binder binder, Component component, String attr) {
        ValidationMessages vmsgs = ((BinderCtrl)((Object)binder)).getValidationMessages();
        if (vmsgs != null) {
            vmsgs.clearMessages(component, attr);
        }
    }

    private boolean validateSaveFormBinding(Component comp, SaveFormBinding binding, String command, Map<String, Property[]> validates, boolean valid, Set<Property> notifys) {
        Set<SaveBinding> savebindings = ((BinderCtrl)((Object)binding.getBinder())).getFormAssociatedSaveBindings(binding.getComponent());
        boolean svalid = true;
        for (SaveBinding sbinding : savebindings) {
            if (!(sbinding instanceof SavePropertyBinding)) continue;
            svalid &= this.validateSavePropertyBinding(comp, (SavePropertyBinding)sbinding, command, validates, svalid & valid, notifys);
        }
        if (!binding.hasValidator()) {
            return svalid;
        }
        if (((BinderImpl)binding.getBinder()).hasValidator(binding.getComponent(), binding.getFormId())) {
            this.clearValidationMessage(binding.getBinder(), binding.getComponent(), binding.getFormId());
        }
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, command, binding.getComponent(), null);
        BindContextUtil.setValidatorArgs(binding.getBinder(), binding.getComponent(), ctx, binding);
        Property p = this._mainPropertyCache.get(binding);
        ValidationContextImpl vContext = new ValidationContextImpl(command, p, validates, ctx, svalid & valid);
        binding.validate(vContext);
        Set<Property> xnotifys = ValidationHelper.getNotifys(ctx);
        if (xnotifys != null) {
            notifys.addAll(xnotifys);
        }
        return svalid && vContext.isValid();
    }

    private static Set<Property> getNotifys(BindContext ctx) {
        return (Set)ctx.getAttribute("$NOTIFYS$");
    }

    static interface InfoProvider {
        public Map<String, List<SavePropertyBinding>> getSaveBeforeBindings();

        public Map<String, List<SavePropertyBinding>> getSaveAfterBindings();

        public Map<String, List<SaveFormBinding>> getSaveFormBeforeBindings();

        public Map<String, List<SaveFormBinding>> getSaveFormAfterBindings();

        public BindingKey getBindingKey(Component var1, String var2);
    }
}

